/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.email;

import java.util.Map;
import org.apache.commons.cli2.Option;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.classifier.email.PrepEmailMapper;
import org.apache.mahout.classifier.email.PrepEmailReducer;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.math.VectorWritable;

public class PrepEmailVectorsDriver
extends AbstractJob {
    public static final String ITEMS_PER_CLASS = "itemsPerClass";
    public static final String USE_LIST_NAME = "USE_LIST_NAME";

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new PrepEmailVectorsDriver(), (String[])args);
    }

    public int run(String[] args) throws Exception {
        this.addInputOption();
        this.addOutputOption();
        this.addOption((Option)DefaultOptionCreator.overwriteOption().create());
        this.addOption("maxItemsPerLabel", "mipl", "The maximum number of items per label.  Can be useful for making the training sets the same size", String.valueOf(100000));
        this.addOption(PrepEmailVectorsDriver.buildOption((String)"useListName", (String)"ul", (String)"Use the name of the list as part of the label.  If not set, then just use the project name", (boolean)false, (boolean)false, (String)"false"));
        Map parsedArgs = this.parseArguments(args);
        if (parsedArgs == null) {
            return -1;
        }
        Path input = this.getInputPath();
        Path output = this.getOutputPath();
        if (this.hasOption("overwrite")) {
            HadoopUtil.delete((Configuration)this.getConf(), (Path[])new Path[]{output});
        }
        Job convertJob = this.prepareJob(input, output, SequenceFileInputFormat.class, PrepEmailMapper.class, Text.class, VectorWritable.class, PrepEmailReducer.class, Text.class, VectorWritable.class, SequenceFileOutputFormat.class);
        convertJob.getConfiguration().set(ITEMS_PER_CLASS, this.getOption("maxItemsPerLabel"));
        convertJob.getConfiguration().set(USE_LIST_NAME, String.valueOf(this.hasOption("useListName")));
        boolean succeeded = convertJob.waitForCompletion(true);
        return succeeded ? 0 : -1;
    }
}

