/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.common.IOUtils;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseSymmetricMatrix;
import org.apache.mahout.math.DistributedRowMatrixWriter;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.hadoop.stochasticsvd.ABtDenseOutJob;
import org.apache.mahout.math.hadoop.stochasticsvd.BtJob;
import org.apache.mahout.math.hadoop.stochasticsvd.Omega;
import org.apache.mahout.math.hadoop.stochasticsvd.QJob;
import org.apache.mahout.math.hadoop.stochasticsvd.SSVDHelper;
import org.apache.mahout.math.hadoop.stochasticsvd.UJob;
import org.apache.mahout.math.hadoop.stochasticsvd.VJob;
import org.apache.mahout.math.solver.EigenDecomposition;

public final class SSVDSolver {
    private Vector svalues;
    private boolean computeU = true;
    private boolean computeV = true;
    private String uPath;
    private String vPath;
    private String uSigmaPath;
    private String uHalfSigmaPath;
    private String vSigmaPath;
    private String vHalfSigmaPath;
    private int outerBlockHeight = 30000;
    private int abtBlockHeight = 200000;
    private final Configuration conf;
    private final Path[] inputPath;
    private final Path outputPath;
    private final int ablockRows;
    private final int k;
    private final int p;
    private int q;
    private final int reduceTasks;
    private int minSplitSize = -1;
    private boolean cUHalfSigma;
    private boolean cUSigma;
    private boolean cVHalfSigma;
    private boolean cVSigma;
    private boolean overwrite;
    private boolean broadcast = true;
    private Path pcaMeanPath;
    private long omegaSeed;

    public SSVDSolver(Configuration conf, Path[] inputPath, Path outputPath, int ablockRows, int k, int p, int reduceTasks) {
        this.conf = conf;
        this.inputPath = inputPath;
        this.outputPath = outputPath;
        this.ablockRows = ablockRows;
        this.k = k;
        this.p = p;
        this.reduceTasks = reduceTasks;
    }

    public int getQ() {
        return this.q;
    }

    public void setQ(int q) {
        this.q = q;
    }

    public void setComputeU(boolean val) {
        this.computeU = val;
    }

    public void setComputeV(boolean val) {
        this.computeV = val;
    }

    public void setcUHalfSigma(boolean cUHat) {
        this.cUHalfSigma = cUHat;
    }

    public void setcVHalfSigma(boolean cVHat) {
        this.cVHalfSigma = cVHat;
    }

    public void setcUSigma(boolean cUSigma) {
        this.cUSigma = cUSigma;
    }

    public void setcVSigma(boolean cVSigma) {
        this.cVSigma = cVSigma;
    }

    public void setMinSplitSize(int size) {
        this.minSplitSize = size;
    }

    public Vector getSingularValues() {
        return this.svalues;
    }

    public String getUPath() {
        return this.uPath;
    }

    public String getVPath() {
        return this.vPath;
    }

    public String getuSigmaPath() {
        return this.uSigmaPath;
    }

    public String getuHalfSigmaPath() {
        return this.uHalfSigmaPath;
    }

    public String getvSigmaPath() {
        return this.vSigmaPath;
    }

    public String getvHalfSigmaPath() {
        return this.vHalfSigmaPath;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public int getOuterBlockHeight() {
        return this.outerBlockHeight;
    }

    public void setOuterBlockHeight(int outerBlockHeight) {
        this.outerBlockHeight = outerBlockHeight;
    }

    public int getAbtBlockHeight() {
        return this.abtBlockHeight;
    }

    public void setAbtBlockHeight(int abtBlockHeight) {
        this.abtBlockHeight = abtBlockHeight;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public Path getPcaMeanPath() {
        return this.pcaMeanPath;
    }

    public void setPcaMeanPath(Path pcaMeanPath) {
        this.pcaMeanPath = pcaMeanPath;
    }

    long getOmegaSeed() {
        return this.omegaSeed;
    }

    public void run() throws IOException {
        LinkedList closeables = Lists.newLinkedList();
        try {
            Class<? extends Writable> labelType = SSVDHelper.sniffInputLabelType(this.inputPath, this.conf);
            FileSystem fs = FileSystem.get((Configuration)this.conf);
            Path qPath = new Path(this.outputPath, "Q-job");
            Path btPath = new Path(this.outputPath, "Bt-job");
            Path uHatPath = new Path(this.outputPath, "UHat");
            Path svPath = new Path(this.outputPath, "Sigma");
            Path uPath = new Path(this.outputPath, "U");
            Path uSigmaPath = new Path(this.outputPath, "USigma");
            Path uHalfSigmaPath = new Path(this.outputPath, "UHalfSigma");
            Path vPath = new Path(this.outputPath, "V");
            Path vHalfSigmaPath = new Path(this.outputPath, "VHalfSigma");
            Path vSigmaPath = new Path(this.outputPath, "VSigma");
            Path pcaBasePath = new Path(this.outputPath, "pca");
            if (this.overwrite) {
                fs.delete(this.outputPath, true);
            }
            if (this.pcaMeanPath != null) {
                fs.mkdirs(pcaBasePath);
            }
            RandomWrapper rnd = RandomUtils.getRandom();
            this.omegaSeed = rnd.nextLong();
            Path sbPath = null;
            double xisquaredlen = 0.0;
            if (this.pcaMeanPath != null) {
                Vector xi = SSVDHelper.loadAndSumUpVectors(this.pcaMeanPath, this.conf);
                if (xi == null) {
                    throw new IOException(String.format("unable to load mean path xi from %s.", this.pcaMeanPath.toString()));
                }
                xisquaredlen = xi.dot(xi);
                Omega omega = new Omega(this.omegaSeed, this.k + this.p);
                Vector s_b0 = omega.mutlithreadedTRightMultiply(xi);
                sbPath = new Path(pcaBasePath, "somega.seq");
                SSVDHelper.saveVector(s_b0, sbPath, this.conf);
            }
            QJob.run(this.conf, this.inputPath, sbPath, qPath, this.ablockRows, this.minSplitSize, this.k, this.p, this.omegaSeed, this.reduceTasks);
            BtJob.run(this.conf, this.inputPath, qPath, this.pcaMeanPath, btPath, this.minSplitSize, this.k, this.p, this.outerBlockHeight, this.q <= 0 ? Math.min(1000, this.reduceTasks) : this.reduceTasks, this.broadcast, labelType, this.q <= 0);
            sbPath = new Path(btPath, "sb-*");
            Path sqPath = new Path(btPath, "sq-*");
            for (int i = 0; i < this.q; ++i) {
                qPath = new Path(this.outputPath, String.format("ABt-job-%d", i + 1));
                Path btPathGlob = new Path(btPath, "part-*");
                ABtDenseOutJob.run(this.conf, this.inputPath, btPathGlob, this.pcaMeanPath, sqPath, sbPath, qPath, this.ablockRows, this.minSplitSize, this.k, this.p, this.abtBlockHeight, this.reduceTasks, this.broadcast);
                btPath = new Path(this.outputPath, String.format("Bt-job-%d", i + 1));
                BtJob.run(this.conf, this.inputPath, qPath, this.pcaMeanPath, btPath, this.minSplitSize, this.k, this.p, this.outerBlockHeight, i == this.q - 1 ? Math.min(1000, this.reduceTasks) : this.reduceTasks, this.broadcast, labelType, i == this.q - 1);
                sbPath = new Path(btPath, "sb-*");
                sqPath = new Path(btPath, "sq-*");
            }
            DenseSymmetricMatrix bbt = SSVDHelper.loadAndSumUpperTriangularMatricesAsSymmetric(new Path(btPath, "bbt-*"), this.conf);
            assert (bbt.columnSize() == this.k + this.p);
            DenseMatrix bbtSquare = new DenseMatrix(this.k + this.p, this.k + this.p);
            bbtSquare.assign((Matrix)bbt);
            if (this.pcaMeanPath != null) {
                Vector sq = SSVDHelper.loadAndSumUpVectors(sqPath, this.conf);
                Vector sb = SSVDHelper.loadAndSumUpVectors(sbPath, this.conf);
                Matrix mC = sq.cross(sb);
                bbtSquare.assign(mC, Functions.MINUS);
                bbtSquare.assign(mC.transpose(), Functions.MINUS);
                Matrix outerSq = sq.cross(sq);
                outerSq.assign(Functions.mult((double)xisquaredlen));
                bbtSquare.assign(outerSq, Functions.PLUS);
            }
            EigenDecomposition eigen = new EigenDecomposition((Matrix)bbtSquare);
            Matrix uHat = eigen.getV();
            this.svalues = eigen.getRealEigenvalues().clone();
            this.svalues.assign(Functions.SQRT);
            fs.mkdirs(uHatPath);
            uHatPath = new Path(uHatPath, "uhat.seq");
            DistributedRowMatrixWriter.write(uHatPath, this.conf, (Iterable<MatrixSlice>)uHat);
            svPath = new Path(svPath, "svalues.seq");
            SSVDHelper.saveVector(this.svalues, svPath, this.conf);
            UJob ujob = null;
            if (this.computeU) {
                ujob = new UJob();
                ujob.run(this.conf, new Path(btPath, "Q-*"), uHatPath, svPath, uPath, this.k, this.reduceTasks, labelType, OutputScalingEnum.NOSCALING);
            }
            UJob uhsjob = null;
            if (this.cUHalfSigma) {
                uhsjob = new UJob();
                uhsjob.run(this.conf, new Path(btPath, "Q-*"), uHatPath, svPath, uHalfSigmaPath, this.k, this.reduceTasks, labelType, OutputScalingEnum.HALFSIGMA);
            }
            UJob usjob = null;
            if (this.cUSigma) {
                usjob = new UJob();
                usjob.run(this.conf, new Path(btPath, "Q-*"), uHatPath, svPath, uSigmaPath, this.k, this.reduceTasks, labelType, OutputScalingEnum.SIGMA);
            }
            VJob vjob = null;
            if (this.computeV) {
                vjob = new VJob();
                vjob.run(this.conf, new Path(btPath, "part-*"), this.pcaMeanPath, sqPath, uHatPath, svPath, vPath, this.k, this.reduceTasks, OutputScalingEnum.NOSCALING);
            }
            VJob vhsjob = null;
            if (this.cVHalfSigma) {
                vhsjob = new VJob();
                vhsjob.run(this.conf, new Path(btPath, "part-*"), this.pcaMeanPath, sqPath, uHatPath, svPath, vHalfSigmaPath, this.k, this.reduceTasks, OutputScalingEnum.HALFSIGMA);
            }
            VJob vsjob = null;
            if (this.cVSigma) {
                vsjob = new VJob();
                vsjob.run(this.conf, new Path(btPath, "part-*"), this.pcaMeanPath, sqPath, uHatPath, svPath, vSigmaPath, this.k, this.reduceTasks, OutputScalingEnum.SIGMA);
            }
            if (ujob != null) {
                ujob.waitForCompletion();
                this.uPath = uPath.toString();
            }
            if (uhsjob != null) {
                uhsjob.waitForCompletion();
                this.uHalfSigmaPath = uHalfSigmaPath.toString();
            }
            if (usjob != null) {
                usjob.waitForCompletion();
                this.uSigmaPath = uSigmaPath.toString();
            }
            if (vjob != null) {
                vjob.waitForCompletion();
                this.vPath = vPath.toString();
            }
            if (vhsjob != null) {
                vhsjob.waitForCompletion();
                this.vHalfSigmaPath = vHalfSigmaPath.toString();
            }
            if (vsjob != null) {
                vsjob.waitForCompletion();
                this.vSigmaPath = vSigmaPath.toString();
            }
        }
        catch (InterruptedException exc) {
            throw new IOException("Interrupted", exc);
        }
        catch (ClassNotFoundException exc) {
            throw new IOException(exc);
        }
        finally {
            IOUtils.close((Collection)closeables);
        }
    }

    static enum OutputScalingEnum {
        NOSCALING,
        SIGMA,
        HALFSIGMA;

    }
}

