/*
 * Decompiled with CFR 0.152.
 */
package smile.wavelet;

import smile.wavelet.Wavelet;

public class DaubechiesWavelet
extends Wavelet {
    private static final double[] c2 = new double[]{0.7071067811865475, 0.7071067811865475};
    private static final double[] c4 = new double[]{0.4829629131445341, 0.8365163037378079, 0.2241438680420134, -0.1294095225512604};
    private static final double[] c6 = new double[]{0.3326705529500825, 0.8068915093110924, 0.4598775021184914, -0.1350110200102546, -0.0854412738820267, 0.0352262918857095};
    private static final double[] c8 = new double[]{0.2303778133088964, 0.7148465705529155, 0.6308807679398587, -0.0279837694168599, -0.1870348117190931, 0.0308413818355607, 0.0328830116668852, -0.010597401785069};
    private static final double[] c10 = new double[]{0.1601023979741929, 0.6038292697971895, 0.7243085284377726, 0.1384281459013203, -0.2422948870663823, -0.0322448695846381, 0.0775714938400459, -0.0062414902127983, -0.012580751999082, 0.0033357252854738};
    private static final double[] c12 = new double[]{0.11154074335, 0.494623890398, 0.751133908021, 0.315250351709, -0.226264693965, -0.129766867567, 0.097501605587, 0.02752286553, -0.031582039318, 5.53842201E-4, 0.004777257511, -0.001077301085};
    private static final double[] c14 = new double[]{0.0778520540850037, 0.3965393194818912, 0.7291320908461957, 0.4697822874051889, -0.1439060039285212, -0.2240361849938412, 0.0713092192668272, 0.0806126091510774, -0.0380299369350104, -0.0165745416306655, 0.0125509985560986, 4.295779729214E-4, -0.0018016407040473, 3.537137999745E-4};
    private static final double[] c16 = new double[]{0.0544158422431072, 0.3128715909143166, 0.6756307362973195, 0.585354683654216, -0.0158291052563823, -0.2840155429615824, 4.724845739124E-4, 0.1287474266204893, -0.017369301001809, -0.0440882539307971, 0.0139810279174001, 0.0087460940474065, -0.004870352993452, -3.91740373377E-4, 6.754494064506E-4, -1.174767841248E-4};
    private static final double[] c18 = new double[]{0.0380779473638778, 0.2438346746125858, 0.6048231236900955, 0.6572880780512736, 0.1331973858249883, -0.2932737832791663, -0.0968407832229492, 0.1485407493381256, 0.0307256814793365, -0.0676328290613279, 2.50947114834E-4, 0.0223616621236798, -0.0047232047577518, -0.0042815036824635, 0.0018476468830563, 2.303857635232E-4, -2.519631889427E-4, 3.93473203163E-5};
    private static final double[] c20 = new double[]{0.026670057901, 0.188176800078, 0.527201188932, 0.688459039454, 0.281172343661, -0.249846424327, -0.195946274377, 0.127369340336, 0.093057364604, -0.071394147166, -0.029457536822, 0.033212674059, 0.003606553567, -0.010733175483, 0.001395351747, 0.001992405295, -6.85856695E-4, -1.16466855E-4, 9.358867E-5, -1.3264203E-5};

    public DaubechiesWavelet(int n) {
        super(n == 2 ? c2 : (n == 4 ? c4 : (n == 6 ? c6 : (n == 8 ? c8 : (n == 10 ? c10 : (n == 12 ? c12 : (n == 14 ? c14 : (n == 16 ? c16 : (n == 18 ? c18 : (double[])(n == 20 ? c20 : null))))))))));
        if (n < 2 || n > 20 || n % 2 != 0) {
            throw new IllegalArgumentException(String.format("n = %d not yet implemented.", n));
        }
    }
}

