/*
 * Decompiled with CFR 0.152.
 */
package smile.vq;

import java.util.Arrays;
import smile.clustering.ClusteringDistance;
import smile.clustering.PartitionClustering;
import smile.math.Math;

public class NeuralGas
extends PartitionClustering<double[]> {
    double distortion;
    double[][] centroids;

    public NeuralGas(double[][] data, int k) {
        this(data, k, Math.min(10, Math.max(1, k / 2)), 0.01, 0.5, 0.005, 25);
    }

    public NeuralGas(double[][] data, int k, double lambda_i, double lambda_f, double eps_i, double eps_f, int steps) {
        int i;
        int j;
        int i2;
        if (k < 2) {
            throw new IllegalArgumentException("Invalid number of clusters: " + k);
        }
        if (lambda_i <= 0.0) {
            throw new IllegalArgumentException("Invalid initial value of lambda: " + lambda_i);
        }
        if (lambda_f <= 0.0) {
            throw new IllegalArgumentException("Invalid final value of lambda: " + lambda_i);
        }
        if (lambda_f >= lambda_i) {
            throw new IllegalArgumentException("lambda_f is NOT less than lambda_i.");
        }
        if (eps_i <= 0.0 || eps_i > 1.0) {
            throw new IllegalArgumentException("Invalid initial value of epsilon: " + eps_i);
        }
        if (eps_f <= 0.0 || eps_f > 1.0) {
            throw new IllegalArgumentException("Invalid final value of epsilon: " + eps_i);
        }
        if (eps_f >= eps_i) {
            throw new IllegalArgumentException("eps_f is NOT less than eps_i.");
        }
        int n = data.length;
        int d = data[0].length;
        this.k = k;
        this.y = NeuralGas.seed(data, k, ClusteringDistance.EUCLIDEAN);
        this.size = new int[k];
        for (i2 = 0; i2 < n; ++i2) {
            int n2 = this.y[i2];
            this.size[n2] = this.size[n2] + 1;
        }
        this.centroids = new double[k][d];
        for (i2 = 0; i2 < n; ++i2) {
            for (j = 0; j < d; ++j) {
                double[] dArray = this.centroids[this.y[i2]];
                int n3 = j;
                dArray[n3] = dArray[n3] + data[i2][j];
            }
        }
        for (i2 = 0; i2 < k; ++i2) {
            j = 0;
            while (j < d) {
                double[] dArray = this.centroids[i2];
                int n4 = j++;
                dArray[n4] = dArray[n4] / (double)this.size[i2];
            }
        }
        Object[] nodes = new Neuron[k];
        for (i = 0; i < k; ++i) {
            nodes[i] = new Neuron(this.centroids[i]);
        }
        for (int t = 0; t < steps; ++t) {
            double tf = (double)t / (double)steps;
            double lambda = lambda_i * Math.pow(lambda_f / lambda_i, tf);
            double eps = eps_i * Math.pow(eps_f / eps_i, tf);
            for (double[] signal : data) {
                for (Object node : nodes) {
                    ((Neuron)node).dist = Math.squaredDistance(((Neuron)node).w, signal);
                }
                Arrays.sort(nodes);
                for (int i3 = 0; i3 < k; ++i3) {
                    double delta = eps * Math.exp((double)(-i3) / lambda);
                    if (!(delta > 0.0)) continue;
                    for (int j2 = 0; j2 < d; ++j2) {
                        int n5 = j2;
                        ((Neuron)nodes[i3]).w[n5] = ((Neuron)nodes[i3]).w[n5] + delta * (signal[j2] - ((Neuron)nodes[i3]).w[j2]);
                    }
                }
            }
        }
        this.distortion = 0.0;
        for (i = 0; i < n; ++i) {
            double nearest = Double.MAX_VALUE;
            for (int j3 = 0; j3 < k; ++j3) {
                double dist = Math.squaredDistance(data[i], this.centroids[j3]);
                if (!(nearest > dist)) continue;
                this.y[i] = j3;
                nearest = dist;
            }
            this.distortion += nearest;
        }
        Arrays.fill(this.size, 0);
        for (i = 0; i < data.length; ++i) {
            int n6 = this.y[i];
            this.size[n6] = this.size[n6] + 1;
        }
    }

    public double distortion() {
        return this.distortion;
    }

    public double[][] centroids() {
        return this.centroids;
    }

    public double[][] neurons() {
        return this.centroids;
    }

    @Override
    public int predict(double[] x) {
        double minDist = Double.MAX_VALUE;
        int bestCluster = 0;
        for (int i = 0; i < this.k; ++i) {
            double dist = Math.squaredDistance(x, this.centroids[i]);
            if (!(dist < minDist)) continue;
            minDist = dist;
            bestCluster = i;
        }
        return bestCluster;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Neural Gas distortion: %.5f\n", this.distortion));
        sb.append(String.format("Clusters of %d data points of dimension %d:\n", this.y.length, this.centroids[0].length));
        for (int i = 0; i < this.k; ++i) {
            int r = (int)Math.round(1000.0 * (double)this.size[i] / (double)this.y.length);
            sb.append(String.format("%3d\t%5d (%2d.%1d%%)\n", i, this.size[i], r / 10, r % 10));
        }
        return sb.toString();
    }

    class Neuron
    implements Comparable<Neuron> {
        double[] w;
        double dist = Double.MAX_VALUE;

        Neuron(double[] w) {
            this.w = w;
        }

        @Override
        public int compareTo(Neuron o) {
            return (int)Math.signum(this.dist - o.dist);
        }
    }
}

