/*
 * Decompiled with CFR 0.152.
 */
package smile.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class ColorCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private static final String EDIT = "edit";
    private Color currentColor;
    private JButton button = new JButton(){

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    };
    private JColorChooser colorChooser;
    private JDialog dialog;

    public ColorCellEditor() {
        this.button.setActionCommand(EDIT);
        this.button.addActionListener(this);
        this.colorChooser = new JColorChooser();
        this.dialog = JColorChooser.createDialog(this.button, "Pick a Color", true, this.colorChooser, this, null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (EDIT.equals(cmd)) {
            this.button.setBackground(this.currentColor);
            this.dialog.setVisible(true);
            this.fireEditingStopped();
        } else {
            this.currentColor = this.colorChooser.getColor();
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.currentColor;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.currentColor = (Color)value;
        return this.button;
    }
}

