/*
 * Decompiled with CFR 0.152.
 */
package smile.projection;

import smile.math.Math;
import smile.math.kernel.MercerKernel;
import smile.math.matrix.EigenValueDecomposition;
import smile.projection.Projection;

public class KPCA<T>
implements Projection<T> {
    private int p;
    private T[] data;
    private MercerKernel<T> kernel;
    private double[] mean;
    private double mu;
    private double[] latent;
    private double[][] projection;
    private double[][] coordinates;

    public KPCA(T[] data, MercerKernel<T> kernel, double threshold) {
        this(data, kernel, data.length, threshold);
    }

    public KPCA(T[] data, MercerKernel<T> kernel, int k) {
        this(data, kernel, k, 1.0E-4);
    }

    public KPCA(T[] data, MercerKernel<T> kernel, int k, double threshold) {
        int j;
        int i;
        if (threshold < 0.0) {
            throw new IllegalArgumentException("Invalid threshold = " + threshold);
        }
        if (k < 1 || k > data.length) {
            throw new IllegalArgumentException("Invalid dimension of feature space: " + k);
        }
        this.data = data;
        this.kernel = kernel;
        int n = data.length;
        double[][] K = new double[n][n];
        for (i = 0; i < n; ++i) {
            for (j = 0; j <= i; ++j) {
                K[i][j] = kernel.k(data[i], data[j]);
                K[j][i] = K[i][j];
            }
        }
        this.mean = Math.rowMean(K);
        this.mu = Math.mean(this.mean);
        for (i = 0; i < n; ++i) {
            for (j = 0; j <= i; ++j) {
                K[i][j] = K[i][j] - this.mean[i] - this.mean[j] + this.mu;
                K[j][i] = K[i][j];
            }
        }
        EigenValueDecomposition eigen = Math.eigen(K, k);
        this.p = 0;
        int i2 = 0;
        while (i2 < k) {
            double[] dArray = eigen.getEigenValues();
            int n2 = i2++;
            double d = dArray[n2] = dArray[n2] / (double)n;
            double e = d;
            if (!(e > threshold)) break;
            ++this.p;
        }
        this.latent = new double[this.p];
        this.projection = new double[this.p][n];
        for (j = 0; j < this.p; ++j) {
            this.latent[j] = eigen.getEigenValues()[j];
            double s = Math.sqrt(this.latent[j]);
            for (int i3 = 0; i3 < n; ++i3) {
                this.projection[j][i3] = eigen.getEigenVectors()[i3][j] / s;
            }
        }
        this.coordinates = new double[n][this.p];
        for (i2 = 0; i2 < n; ++i2) {
            Math.ax(this.projection, K[i2], this.coordinates[i2]);
        }
    }

    public double[] getVariances() {
        return this.latent;
    }

    public double[][] getProjection() {
        return this.projection;
    }

    public double[][] getCoordinates() {
        return this.coordinates;
    }

    @Override
    public double[] project(T x) {
        int n = this.data.length;
        double[] y = new double[n];
        for (int i = 0; i < n; ++i) {
            y[i] = this.kernel.k(x, this.data[i]);
        }
        double my = Math.mean(y);
        for (int i = 0; i < n; ++i) {
            y[i] = y[i] - my - this.mean[i] + this.mu;
        }
        double[] z = new double[this.p];
        Math.ax(this.projection, y, z);
        return z;
    }

    @Override
    public double[][] project(T[] x) {
        int m = x.length;
        int n = this.data.length;
        double[][] y = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                y[i][j] = this.kernel.k(x[i], this.data[j]);
            }
            double my = Math.mean(y[i]);
            for (int j = 0; j < n; ++j) {
                y[i][j] = y[i][j] - my - this.mean[j] + this.mu;
            }
        }
        double[][] z = new double[x.length][this.p];
        for (int i = 0; i < y.length; ++i) {
            Math.ax(this.projection, y[i], z[i]);
        }
        return z;
    }
}

