/*
 * Decompiled with CFR 0.152.
 */
package smile.plot;

import java.awt.Color;
import smile.plot.Graphics;
import smile.plot.Plot;
import smile.plot.PlotCanvas;

public class Dendrogram
extends Plot {
    private double[][] p1;
    private double[][] p2;
    private double height;

    public Dendrogram(int[][] merge, double[] height) {
        this(merge, height, Color.BLACK);
    }

    public Dendrogram(int[][] merge, double[] height, Color color) {
        super(color);
        int i;
        int n = merge.length + 1;
        int[] order = new int[n];
        this.dfs(merge, n - 2, order, 0);
        double[][] pos = new double[2 * n - 1][2];
        for (i = 0; i < n; ++i) {
            pos[order[i]][0] = i;
            pos[order[i]][1] = 0.0;
        }
        for (i = 0; i < merge.length; ++i) {
            pos[n + i][0] = (pos[merge[i][0]][0] + pos[merge[i][1]][0]) / 2.0;
            pos[n + i][1] = Math.max(pos[merge[i][0]][1], pos[merge[i][1]][1]) + height[i];
        }
        this.p1 = new double[3 * n - 3][2];
        this.p2 = new double[3 * n - 3][2];
        for (i = 0; i < merge.length; ++i) {
            this.p1[3 * i][0] = pos[merge[i][0]][0];
            this.p1[3 * i][1] = pos[merge[i][0]][1];
            this.p2[3 * i][0] = pos[merge[i][0]][0];
            this.p2[3 * i][1] = pos[n + i][1];
            this.p1[3 * i + 1][0] = pos[merge[i][1]][0];
            this.p1[3 * i + 1][1] = pos[merge[i][1]][1];
            this.p2[3 * i + 1][0] = pos[merge[i][1]][0];
            this.p2[3 * i + 1][1] = pos[n + i][1];
            this.p1[3 * i + 2][0] = pos[merge[i][0]][0];
            this.p1[3 * i + 2][1] = pos[n + i][1];
            this.p2[3 * i + 2][0] = pos[merge[i][1]][0];
            this.p2[3 * i + 2][1] = pos[n + i][1];
        }
        this.height = pos[2 * n - 2][1];
    }

    public double getHeight() {
        return this.height;
    }

    private int dfs(int[][] merge, int index, int[] order, int i) {
        int n = merge.length + 1;
        if (merge[index][0] > merge.length) {
            i = this.dfs(merge, merge[index][0] - n, order, i);
        } else {
            order[i++] = merge[index][0];
        }
        if (merge[index][1] > merge.length) {
            i = this.dfs(merge, merge[index][1] - n, order, i);
        } else {
            order[i++] = merge[index][1];
        }
        return i;
    }

    @Override
    public void paint(Graphics g) {
        Color c = g.getColor();
        g.setColor(this.getColor());
        for (int i = 0; i < this.p1.length; ++i) {
            g.drawLine(this.p1[i], this.p2[i]);
        }
        g.setColor(c);
    }

    public static PlotCanvas plot(int[][] merge, double[] height) {
        int n = merge.length + 1;
        Dendrogram dendrogram = new Dendrogram(merge, height);
        double[] lowerBound = new double[]{-n / 100, 0.0};
        double[] upperBound = new double[]{n + n / 100, 1.01 * dendrogram.getHeight()};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound, false);
        canvas.getAxis(0).setGridVisible(false);
        canvas.getAxis(0).setLabelVisible(false);
        canvas.add(dendrogram);
        return canvas;
    }

    public static PlotCanvas plot(String id, int[][] merge, double[] height) {
        int n = merge.length + 1;
        Dendrogram dendrogram = new Dendrogram(merge, height);
        double[] lowerBound = new double[]{-n / 100, 0.0};
        double[] upperBound = new double[]{n + n / 100, 1.01 * dendrogram.getHeight()};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound, false);
        canvas.getAxis(0).setGridVisible(false);
        canvas.getAxis(0).setLabelVisible(false);
        dendrogram.setID(id);
        canvas.add(dendrogram);
        return canvas;
    }
}

