/*
 * Decompiled with CFR 0.152.
 */
package smile.plot;

import java.util.Arrays;
import smile.math.Math;

public class Base {
    int dimension;
    double[][] baseCoords;
    double[] lowerBound;
    double[] upperBound;
    private double[] precisionUnit;
    private int[] precisionDigits;
    private double[] originalLowerBound;
    private double[] originalUpperBound;
    private boolean[] extendBound;

    public Base(double[] lowerBound, double[] upperBound) {
        this(lowerBound, upperBound, true);
    }

    public Base(double[] lowerBound, double[] upperBound, boolean extendBound) {
        if (lowerBound.length != upperBound.length) {
            throw new IllegalArgumentException("Lower bound and upper bound size don't match.");
        }
        if (lowerBound.length != 2 && lowerBound.length != 3) {
            throw new IllegalArgumentException("Invalid bound dimension: " + lowerBound.length);
        }
        this.dimension = lowerBound.length;
        for (int i = 0; i < this.dimension; ++i) {
            if (lowerBound[i] > upperBound[i]) {
                throw new IllegalArgumentException("Lower bound is larger than upper bound.");
            }
            if (lowerBound[i] != upperBound[i]) continue;
            int n = i;
            lowerBound[n] = lowerBound[n] - 1.0;
            int n2 = i;
            upperBound[n2] = upperBound[n2] + 1.0;
        }
        this.originalLowerBound = lowerBound;
        this.originalUpperBound = upperBound;
        this.extendBound = new boolean[this.dimension];
        Arrays.fill(this.extendBound, extendBound);
        this.precisionDigits = new int[this.dimension];
        this.precisionUnit = new double[this.dimension];
        this.lowerBound = new double[this.dimension];
        this.upperBound = new double[this.dimension];
        this.reset();
    }

    public void reset() {
        int i;
        for (i = 0; i < this.dimension; ++i) {
            this.lowerBound[i] = this.originalLowerBound[i];
            this.upperBound[i] = this.originalUpperBound[i];
            this.setPrecisionUnit(i);
        }
        for (i = 0; i < this.dimension; ++i) {
            if (!this.extendBound[i]) continue;
            this.extendBound(i);
        }
        this.initBaseCoord();
    }

    void initBaseCoord() {
        this.baseCoords = new double[this.dimension + 1][];
        for (int i = 0; i < this.baseCoords.length; ++i) {
            this.baseCoords[i] = (double[])this.lowerBound.clone();
            if (i <= 0) continue;
            this.baseCoords[i][i - 1] = this.upperBound[i - 1];
        }
    }

    public int getDimension() {
        return this.dimension;
    }

    void setPrecisionUnit(int i) {
        if (this.upperBound[i] > this.lowerBound[i]) {
            double digits = Math.log10(Math.abs(this.upperBound[i] - this.lowerBound[i]));
            double residual = digits - Math.floor(digits);
            if (residual < 0.2) {
                digits -= 1.0;
            }
            this.precisionDigits[i] = (int)Math.floor(digits);
            this.precisionUnit[i] = Math.pow(10.0, (double)this.precisionDigits[i]);
            if (residual >= 0.2 && residual <= 0.7) {
                int n = i;
                this.precisionUnit[n] = this.precisionUnit[n] / 2.0;
                int n2 = i;
                this.precisionDigits[n2] = this.precisionDigits[n2] - 1;
            }
        } else {
            this.precisionUnit[i] = 0.1;
        }
    }

    public void extendBound(int i) {
        if (i < 0 || i >= this.dimension) {
            throw new IllegalArgumentException("Invalid bound index: " + i);
        }
        this.extendBound[i] = true;
        this.lowerBound[i] = this.precisionUnit[i] * Math.floor(this.originalLowerBound[i] / this.precisionUnit[i]);
        this.upperBound[i] = this.precisionUnit[i] * Math.ceil(this.originalUpperBound[i] / this.precisionUnit[i]);
    }

    public double[][] getCoordinateSpace() {
        return this.baseCoords;
    }

    public double[] getLowerBounds() {
        return this.lowerBound;
    }

    public double[] getUpperBounds() {
        return this.upperBound;
    }

    public double[] getPrecisionUnit() {
        return this.precisionUnit;
    }

    public int[] getPrecisionDigits() {
        return this.precisionDigits;
    }

    public void extendLowerBound(double[] bound) {
        if (bound.length != this.dimension) {
            throw new IllegalArgumentException("Bound size don't match the dimension.");
        }
        boolean extend = false;
        for (int i = 0; i < bound.length; ++i) {
            if (!(bound[i] < this.originalLowerBound[i])) continue;
            this.originalLowerBound[i] = bound[i];
            extend = true;
        }
        if (extend) {
            this.reset();
        }
    }

    public void extendUpperBound(double[] bound) {
        if (bound.length != this.dimension) {
            throw new IllegalArgumentException("Bound size don't match the dimension.");
        }
        boolean extend = false;
        for (int i = 0; i < bound.length; ++i) {
            if (!(bound[i] > this.originalUpperBound[i])) continue;
            this.originalUpperBound[i] = bound[i];
            extend = true;
        }
        if (extend) {
            this.reset();
        }
    }

    public void extendBound(double[] lowerBound, double[] upperBound) {
        int i;
        if (lowerBound.length != this.dimension || upperBound.length != this.dimension) {
            throw new IllegalArgumentException("Bound size don't match the dimension.");
        }
        boolean extend = false;
        for (i = 0; i < lowerBound.length; ++i) {
            if (!(lowerBound[i] < this.originalLowerBound[i])) continue;
            this.originalLowerBound[i] = lowerBound[i];
            extend = true;
        }
        for (i = 0; i < upperBound.length; ++i) {
            if (!(upperBound[i] > this.originalUpperBound[i])) continue;
            this.originalUpperBound[i] = upperBound[i];
            extend = true;
        }
        if (extend) {
            this.reset();
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder(String.format("Base[%d]{", this.dimension));
        for (int i = 0; i < this.baseCoords.length; ++i) {
            s.append("[");
            for (int j = 0; j < this.baseCoords[i].length; ++j) {
                s.append(this.baseCoords[i][j]).append(',');
            }
            s.setCharAt(s.length() - 1, ']');
        }
        s.append('}');
        return s.toString();
    }
}

