/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.Math;
import smile.math.kernel.MercerKernel;

public class BinarySparsePolynomialKernel
implements MercerKernel<int[]> {
    private int degree;
    private double scale;
    private double offset;

    public BinarySparsePolynomialKernel(int degree) {
        this(degree, 1.0, 0.0);
    }

    public BinarySparsePolynomialKernel(int degree, double scale, double offset) {
        if (degree <= 0) {
            throw new IllegalArgumentException("Non-positive polynomial degree.");
        }
        if (offset < 0.0) {
            throw new IllegalArgumentException("Negative offset: the kernel does not satisfy Mercer's condition.");
        }
        this.degree = degree;
        this.scale = scale;
        this.offset = offset;
    }

    public String toString() {
        return String.format("Sparse Binary Polynomial Kernel (scale = %.4f, offset = %.4f)", this.scale, this.offset);
    }

    @Override
    public double k(int[] x, int[] y) {
        double dot = 0.0;
        int p1 = 0;
        int p2 = 0;
        while (p1 < x.length && p2 < y.length) {
            int i1 = x[p1];
            int i2 = y[p2];
            if (i1 == i2) {
                dot += 1.0;
                ++p1;
                ++p2;
                continue;
            }
            if (i1 > i2) {
                ++p2;
                continue;
            }
            ++p1;
        }
        return Math.pow(this.scale * dot + this.offset, (double)this.degree);
    }
}

