/*
 * Decompiled with CFR 0.152.
 */
package smile.math;

import java.util.Arrays;
import smile.math.Math;

public class Histogram {
    public static double[][] histogram(int[] data) {
        return Histogram.histogram(data, Histogram.bins(data.length));
    }

    public static double[][] histogram(float[] data) {
        return Histogram.histogram(data, Histogram.bins(data.length));
    }

    public static double[][] histogram(double[] data) {
        return Histogram.histogram(data, Histogram.bins(data.length));
    }

    public static double[][] histogram(int[] data, int k) {
        if (k <= 1) {
            throw new IllegalArgumentException("Invalid number of bins: " + k);
        }
        int min = Math.min(data);
        int max = Math.max(data);
        int span = max - min + 1;
        int width = 1;
        int residual = 1;
        while (residual > 0) {
            width = span / k;
            if (width == 0) {
                width = 1;
            }
            if ((residual = span - k * width) <= 0) continue;
            ++k;
        }
        double center = (double)width / 2.0;
        double[] breaks = new double[k + 1];
        breaks[0] = (double)min - center;
        for (int i = 1; i <= k; ++i) {
            breaks[i] = breaks[i - 1] + (double)width;
        }
        return Histogram.histogram(data, breaks);
    }

    public static double[][] histogram(int[] data, double[] breaks) {
        int k = breaks.length - 1;
        if (k <= 1) {
            throw new IllegalArgumentException("Invalid number of bins: " + k);
        }
        double[][] freq = new double[3][k];
        for (int i = 0; i < k; ++i) {
            freq[0][i] = breaks[i];
            freq[1][i] = breaks[i + 1];
            freq[2][i] = 0.0;
        }
        for (int d : data) {
            int j = Arrays.binarySearch(breaks, (double)d);
            if (j >= k) {
                j = k - 1;
            }
            if (j < -1 && j >= -breaks.length) {
                j = -j - 2;
            }
            if (j < 0) continue;
            double[] dArray = freq[2];
            int n = j;
            dArray[n] = dArray[n] + 1.0;
        }
        return freq;
    }

    public static double[][] histogram(float[] data, int k) {
        if (k <= 1) {
            throw new IllegalArgumentException("Invalid number of bins: " + k);
        }
        float min = Math.min(data);
        float max = Math.max(data);
        float span = max - min;
        if (span == 0.0f) {
            span = k;
        }
        float width = span / (float)k;
        float[] breaks = new float[k + 1];
        breaks[0] = min;
        for (int i = 1; i < k; ++i) {
            breaks[i] = breaks[i - 1] + width;
        }
        breaks[k] = max;
        return Histogram.histogram(data, breaks);
    }

    public static double[][] histogram(float[] data, float[] breaks) {
        int k = breaks.length - 1;
        if (k <= 1) {
            throw new IllegalArgumentException("Invalid number of bins: " + k);
        }
        double[][] freq = new double[3][k];
        for (int i = 0; i < k; ++i) {
            freq[0][i] = breaks[i];
            freq[1][i] = breaks[i + 1];
            freq[2][i] = 0.0;
        }
        for (float d : data) {
            int j = Arrays.binarySearch(breaks, d);
            if (j >= k) {
                j = k - 1;
            }
            if (j < -1 && j >= -breaks.length) {
                j = -j - 2;
            }
            if (j < 0) continue;
            double[] dArray = freq[2];
            int n = j;
            dArray[n] = dArray[n] + 1.0;
        }
        return freq;
    }

    public static double[][] histogram(double[] data, int k) {
        double min = Math.min(data);
        double max = Math.max(data);
        double span = max - min;
        if (span == 0.0) {
            span = k;
        }
        double width = span / (double)k;
        double[] breaks = new double[k + 1];
        breaks[0] = min;
        for (int i = 1; i < k; ++i) {
            breaks[i] = breaks[i - 1] + width;
        }
        breaks[k] = max;
        return Histogram.histogram(data, breaks);
    }

    public static double[][] histogram(double[] data, double[] breaks) {
        int k = breaks.length - 1;
        if (k <= 1) {
            throw new IllegalArgumentException("Invalid number of bins: " + k);
        }
        double[][] freq = new double[3][k];
        for (int i = 0; i < k; ++i) {
            freq[0][i] = breaks[i];
            freq[1][i] = breaks[i + 1];
            freq[2][i] = 0.0;
        }
        for (double d : data) {
            int j = Arrays.binarySearch(breaks, d);
            if (j >= k) {
                j = k - 1;
            }
            if (j < -1 && j >= -breaks.length) {
                j = -j - 2;
            }
            if (j < 0) continue;
            double[] dArray = freq[2];
            int n = j;
            dArray[n] = dArray[n] + 1.0;
        }
        return freq;
    }

    public static double[] breaks(double[] x, double h) {
        return Histogram.breaks(Math.min(x), Math.max(x), h);
    }

    public static double[] breaks(double min, double max, double h) {
        if (h <= 0.0) {
            throw new IllegalArgumentException("Invalid bin width: " + h);
        }
        if (min > max) {
            throw new IllegalArgumentException("Invalid lower and upper bounds: " + min + " > " + max);
        }
        int k = (int)Math.ceil((max - min) / h);
        double[] breaks = new double[k + 1];
        breaks[0] = min - (h * (double)k - (max - min)) / 2.0;
        breaks[k] = max + (h * (double)k - (max - min)) / 2.0;
        for (int i = 1; i < k; ++i) {
            breaks[i] = breaks[i - 1] + h;
        }
        return breaks;
    }

    public static double[] breaks(double[] x, int k) {
        return Histogram.breaks(Math.min(x), Math.max(x), k);
    }

    public static double[] breaks(double min, double max, int k) {
        if (k <= 1) {
            throw new IllegalArgumentException("Invalid number of bins: " + k);
        }
        if (min > max) {
            throw new IllegalArgumentException("Invalid lower and upper bounds: " + min + " > " + max);
        }
        double h = (max - min) / (double)k;
        return Histogram.breaks(min, max, h);
    }

    public static int bins(double[] x, double h) {
        if (h <= 0.0) {
            throw new IllegalArgumentException("Invalid bin width: " + h);
        }
        double max = Math.max(x);
        double min = Math.min(x);
        return (int)Math.ceil((max - min) / h);
    }

    public static int bins(int n) {
        int k = (int)Math.sqrt(n);
        if (k < 5) {
            k = 5;
        }
        return k;
    }

    public static int sturges(int n) {
        int k = (int)Math.ceil(Math.log2(n) + 1.0);
        if (k < 5) {
            k = 5;
        }
        return k;
    }

    public static int scott(double[] x) {
        double h = Math.ceil(3.5 * Math.sd(x) / Math.pow(x.length, 0.3333333333333333));
        return Histogram.bins(x, h);
    }
}

