/*
 * Decompiled with CFR 0.152.
 */
package smile.manifold;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.SparseDataset;
import smile.graph.AdjacencyList;
import smile.graph.Graph;
import smile.math.Math;
import smile.math.SparseArray;
import smile.math.distance.EuclideanDistance;
import smile.math.matrix.EigenValueDecomposition;
import smile.math.matrix.SparseMatrix;
import smile.neighbor.CoverTree;
import smile.neighbor.KDTree;
import smile.neighbor.NearestNeighborSearch;
import smile.neighbor.Neighbor;

public class LaplacianEigenmap {
    private static final Logger logger = LoggerFactory.getLogger(LaplacianEigenmap.class);
    private double t;
    private int[] index;
    private double[][] coordinates;
    private Graph graph;

    public LaplacianEigenmap(double[][] data, int d, int k) {
        this(data, d, k, -1.0);
    }

    public LaplacianEigenmap(double[][] data, int d, int k, double t) {
        this.t = t;
        int n = data.length;
        NearestNeighborSearch knn = null;
        knn = data[0].length < 10 ? new KDTree(data, (E[])data) : new CoverTree<double[]>((E[])data, new EuclideanDistance());
        this.graph = new AdjacencyList(n);
        for (int i = 0; i < n; ++i) {
            Neighbor<double[], V>[] neighbors = knn.knn(data[i], k);
            for (int j = 0; j < k; ++j) {
                this.graph.setWeight(i, neighbors[j].index, neighbors[j].distance);
            }
        }
        int[][] cc = this.graph.bfs();
        if (cc.length == 1) {
            this.index = new int[n];
            for (int i = 0; i < n; ++i) {
                this.index[i] = i;
            }
        } else {
            n = 0;
            int component = 0;
            for (int i = 0; i < cc.length; ++i) {
                if (cc[i].length <= n) continue;
                component = i;
                n = cc[i].length;
            }
            logger.info("Laplacian Eigenmap: {} connected components, largest one has {} samples.", (Object)cc.length, (Object)n);
            this.index = cc[component];
            this.graph = this.graph.subgraph(this.index);
        }
        SparseDataset W = new SparseDataset(n);
        double[] D = new double[n];
        if (t <= 0.0) {
            for (int i = 0; i < n; ++i) {
                W.set(i, i, 1.0);
                Collection<Graph.Edge> edges = this.graph.getEdges(i);
                for (Graph.Edge edge : edges) {
                    int j = edge.v2;
                    if (i == j) {
                        j = edge.v1;
                    }
                    W.set(i, j, 1.0);
                    int n2 = i;
                    D[n2] = D[n2] + 1.0;
                }
                D[i] = 1.0 / Math.sqrt(D[i]);
            }
        } else {
            double gamma = -1.0 / t;
            for (int i = 0; i < n; ++i) {
                W.set(i, i, 1.0);
                Collection<Graph.Edge> edges = this.graph.getEdges(i);
                for (Graph.Edge edge : edges) {
                    int j = edge.v2;
                    if (i == j) {
                        j = edge.v1;
                    }
                    double w = Math.exp(gamma * Math.sqr(edge.weight));
                    W.set(i, j, w);
                    int n3 = i;
                    D[n3] = D[n3] + w;
                }
                D[i] = 1.0 / Math.sqrt(D[i]);
            }
        }
        SparseMatrix L = W.toSparseMatrix();
        for (int i = 0; i < n; ++i) {
            SparseArray edges = (SparseArray)W.get((int)i).x;
            for (SparseArray.Entry edge : edges) {
                int j = edge.i;
                double s = D[i] * edge.x * D[j];
                L.set(i, j, s);
            }
            L.set(i, i, -1.0);
        }
        double[] v = new double[n];
        for (int i = 0; i < n; ++i) {
            v[i] = Math.random();
        }
        double lambda = -Math.eigen(L, v, 1.0E-6);
        for (int i = 0; i < n; ++i) {
            L.set(i, i, lambda - 1.0);
        }
        EigenValueDecomposition eigen = EigenValueDecomposition.decompose(L, d + 1);
        this.coordinates = new double[n][d];
        for (int j = 0; j < d; ++j) {
            int i;
            double norm = 0.0;
            for (i = 0; i < n; ++i) {
                this.coordinates[i][j] = eigen.getEigenVectors()[i][j + 1] * D[i];
                norm += this.coordinates[i][j] * this.coordinates[i][j];
            }
            norm = Math.sqrt(norm);
            for (i = 0; i < n; ++i) {
                double[] dArray = this.coordinates[i];
                int n4 = j;
                dArray[n4] = dArray[n4] / norm;
            }
        }
    }

    public int[] getIndex() {
        return this.index;
    }

    public double[][] getCoordinates() {
        return this.coordinates;
    }

    public Graph getNearestNeighborGraph() {
        return this.graph;
    }

    public double getHeatKernelWidth() {
        return this.t;
    }
}

