/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.text.ParseException;

public abstract class Attribute {
    private Type type;
    private double weight;
    private String name;
    private String description;

    public Attribute(Type type, String name) {
        this(type, name, 1.0);
    }

    public Attribute(Type type, String name, double weight) {
        this(type, name, null, weight);
    }

    public Attribute(Type type, String name, String description) {
        this(type, name, description, 1.0);
    }

    public Attribute(Type type, String name, String description, double weight) {
        this.type = type;
        this.name = name;
        this.description = description;
        this.weight = weight;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Attribute setName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Attribute setDescription(String description) {
        this.description = description;
        return this;
    }

    public double getWeight() {
        return this.weight;
    }

    public Attribute setWeight(double weight) {
        this.weight = weight;
        return this;
    }

    public abstract String toString(double var1);

    public abstract double valueOf(String var1) throws ParseException;

    public boolean equals(Object o) {
        if (o instanceof Attribute) {
            Attribute a = (Attribute)o;
            if (this.name.equals(a.name) && this.type == a.type) {
                return this.description != null && a.description != null && this.description.equals(a.description);
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + this.type.hashCode();
        hash = 37 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 37 * hash + (this.description != null ? this.description.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.type);
        sb.append('[');
        sb.append(this.name);
        sb.append(']');
        return sb.toString();
    }

    public static enum Type {
        NUMERIC,
        NOMINAL,
        STRING,
        DATE;

    }
}

