/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.tree;

import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.util.Contract;

public final class TreeModelSupport {
    protected EventListenerList listeners;
    private TreeModel treeModel;

    public TreeModelSupport(TreeModel model) {
        if (model == null) {
            throw new NullPointerException("model must not be null");
        }
        this.listeners = new EventListenerList();
        this.treeModel = model;
    }

    public void fireNewRoot() {
        Object root = this.treeModel.getRoot();
        TreePath path = root != null ? new TreePath(root) : null;
        this.fireTreeStructureChanged(path);
    }

    public void firePathLeafStateChanged(TreePath path) {
        this.fireTreeStructureChanged(path);
    }

    public void fireTreeStructureChanged(TreePath subTreePath) {
        if (subTreePath != null) {
            Contract.asNotNull(subTreePath.getPath(), "path must not contain null elements");
        }
        Object[] pairs = this.listeners.getListenerList();
        TreeModelEvent e = null;
        for (int i = pairs.length - 2; i >= 0; i -= 2) {
            if (pairs[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = this.createStructureChangedEvent(subTreePath);
            }
            ((TreeModelListener)pairs[i + 1]).treeStructureChanged(e);
        }
    }

    public void firePathChanged(TreePath path) {
        Object node = path.getLastPathComponent();
        TreePath parentPath = path.getParentPath();
        if (parentPath == null) {
            this.fireChildrenChanged(path, null, null);
        } else {
            Object parent = parentPath.getLastPathComponent();
            this.fireChildChanged(parentPath, this.treeModel.getIndexOfChild(parent, node), node);
        }
    }

    public void fireChildChanged(TreePath parentPath, int index, Object child) {
        this.fireChildrenChanged(parentPath, new int[]{index}, new Object[]{child});
    }

    public void fireChildrenChanged(TreePath parentPath, int[] indices, Object[] children2) {
        Contract.asNotNull(parentPath.getPath(), "path must not be null and must not contain null elements");
        Object[] pairs = this.listeners.getListenerList();
        TreeModelEvent e = null;
        for (int i = pairs.length - 2; i >= 0; i -= 2) {
            if (pairs[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = this.createTreeModelEvent(parentPath, indices, children2);
            }
            ((TreeModelListener)pairs[i + 1]).treeNodesChanged(e);
        }
    }

    public void fireChildAdded(TreePath parentPath, int index, Object child) {
        this.fireChildrenAdded(parentPath, new int[]{index}, new Object[]{child});
    }

    public void fireChildRemoved(TreePath parentPath, int index, Object child) {
        this.fireChildrenRemoved(parentPath, new int[]{index}, new Object[]{child});
    }

    public void fireChildrenAdded(TreePath parentPath, int[] indices, Object[] children2) {
        Object[] pairs = this.listeners.getListenerList();
        TreeModelEvent e = null;
        for (int i = pairs.length - 2; i >= 0; i -= 2) {
            if (pairs[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = this.createTreeModelEvent(parentPath, indices, children2);
            }
            ((TreeModelListener)pairs[i + 1]).treeNodesInserted(e);
        }
    }

    public void fireChildrenRemoved(TreePath parentPath, int[] indices, Object[] children2) {
        Object[] pairs = this.listeners.getListenerList();
        TreeModelEvent e = null;
        for (int i = pairs.length - 2; i >= 0; i -= 2) {
            if (pairs[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = this.createTreeModelEvent(parentPath, indices, children2);
            }
            ((TreeModelListener)pairs[i + 1]).treeNodesRemoved(e);
        }
    }

    private TreeModelEvent createStructureChangedEvent(TreePath parentPath) {
        return this.createTreeModelEvent(parentPath, null, null);
    }

    private TreeModelEvent createTreeModelEvent(TreePath parentPath, int[] indices, Object[] children2) {
        return new TreeModelEvent((Object)this.treeModel, parentPath, indices, children2);
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(TreeModelListener.class, l);
    }

    public TreeModelListener[] getTreeModelListeners() {
        return (TreeModelListener[])this.listeners.getListeners(TreeModelListener.class);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(TreeModelListener.class, l);
    }
}

