/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli2.Option;
import org.apache.commons.io.Charsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.classifier.ConfusionMatrix;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixWritable;

public final class ConfusionMatrixDumper
extends AbstractJob {
    private static final String TAB_SEPARATOR = "|";
    private static final String HEADER = "<html><head>\n<title>TITLE</title>\n</head><body>\n<style type='text/css'> \ntable\n{\nborder:3px solid black; text-align:left;\n}\nth.normalHeader\n{\nborder:1px solid black;border-collapse:collapse;text-align:center;background-color:white\n}\nth.tallHeader\n{\nborder:1px solid black;border-collapse:collapse;text-align:center;background-color:white; height:6em\n}\ntr.label\n{\nborder:1px solid black;border-collapse:collapse;text-align:center;background-color:white\n}\ntr.row\n{\nborder:1px solid gray;text-align:center;background-color:snow\n}\ntd\n{\nmin-width:2em\n}\ntd.cell\n{\nborder:1px solid black;text-align:right;background-color:snow\n}\ntd.empty\n{\nborder:0px;text-align:right;background-color:snow\n}\ntd.white\n{\nborder:0px solid black;text-align:right;background-color:white\n}\ntd.black\n{\nborder:0px solid red;text-align:right;background-color:black\n}\ntd.gray1\n{\nborder:0px solid green;text-align:right; background-color:LightGray\n}\ntd.gray2\n{\nborder:0px solid blue;text-align:right;background-color:gray\n}\ntd.gray3\n{\nborder:0px solid red;text-align:right;background-color:DarkGray\n}\nth{\n        text-align: center;\n        vertical-align: bottom;\n        padding-bottom: 3px;\n        padding-left: 5px;\n        padding-right: 5px;\n}\n     .verticalText\n      {\n        text-align: center;\n        vertical-align: middle;\n        width: 20px;\n        margin: 0px;\n        padding: 0px;\n        padding-left: 3px;\n        padding-right: 3px;\n        padding-top: 10px;\n        white-space: nowrap;\n        -webkit-transform: rotate(-90deg); \n        -moz-transform: rotate(-90deg);         \n      };\n</style>\n";
    private static final String FOOTER = "</html></body>";
    private static final String CSS_TABLE = "table";
    private static final String CSS_LABEL = "label";
    private static final String CSS_TALL_HEADER = "tall";
    private static final String CSS_VERTICAL = "verticalText";
    private static final String CSS_CELL = "cell";
    private static final String CSS_EMPTY = "empty";
    private static final String[] CSS_GRAY_CELLS = new String[]{"white", "gray1", "gray2", "gray3", "black"};

    private ConfusionMatrixDumper() {
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new ConfusionMatrixDumper(), (String[])args);
    }

    public int run(String[] args) throws IOException {
        this.addInputOption();
        this.addOption("output", "o", "Output path", null);
        this.addOption((Option)DefaultOptionCreator.overwriteOption().create());
        this.addFlag("html", null, "Create complete HTML page");
        this.addFlag("text", null, "Dump simple text");
        Map parsedArgs = this.parseArguments(args);
        if (parsedArgs == null) {
            return -1;
        }
        Path inputPath = this.getInputPath();
        String outputFile = this.hasOption("output") ? this.getOption("output") : null;
        boolean text = parsedArgs.containsKey("--text");
        boolean wrapHtml = parsedArgs.containsKey("--html");
        PrintStream out = ConfusionMatrixDumper.getPrintStream(outputFile);
        if (text) {
            ConfusionMatrixDumper.exportText(inputPath, out);
        } else {
            ConfusionMatrixDumper.exportTable(inputPath, out, wrapHtml);
        }
        out.flush();
        if (out != System.out) {
            out.close();
        }
        return 0;
    }

    private static void exportText(Path inputPath, PrintStream out) throws IOException {
        MatrixWritable mw = new MatrixWritable();
        Text key = new Text();
        ConfusionMatrixDumper.readSeqFile(inputPath, key, mw);
        Matrix m = mw.get();
        ConfusionMatrix cm = new ConfusionMatrix(m);
        out.println(String.format("%-40s", "Label") + TAB_SEPARATOR + String.format("%-10s", "Total") + TAB_SEPARATOR + String.format("%-10s", "Correct") + TAB_SEPARATOR + String.format("%-6s", "%") + TAB_SEPARATOR);
        out.println(String.format("%-70s", "-").replace(' ', '-'));
        List<String> labels = ConfusionMatrixDumper.stripDefault(cm);
        for (String label : labels) {
            int correct = cm.getCorrect(label);
            double accuracy = cm.getAccuracy(label);
            int count = ConfusionMatrixDumper.getCount(cm, label);
            out.println(String.format("%-40s", label) + TAB_SEPARATOR + String.format("%-10s", count) + TAB_SEPARATOR + String.format("%-10s", correct) + TAB_SEPARATOR + String.format("%-6s", (int)Math.round(accuracy)) + TAB_SEPARATOR);
        }
        out.println(String.format("%-70s", "-").replace(' ', '-'));
        out.println(cm.toString());
    }

    private static void exportTable(Path inputPath, PrintStream out, boolean wrapHtml) throws IOException {
        MatrixWritable mw = new MatrixWritable();
        Text key = new Text();
        ConfusionMatrixDumper.readSeqFile(inputPath, key, mw);
        String fileName = inputPath.getName();
        fileName = fileName.substring(fileName.lastIndexOf(47) + 1, fileName.length());
        Matrix m = mw.get();
        ConfusionMatrix cm = new ConfusionMatrix(m);
        if (wrapHtml) {
            ConfusionMatrixDumper.printHeader(out, fileName);
        }
        out.println("<p/>");
        ConfusionMatrixDumper.printSummaryTable(cm, out);
        out.println("<p/>");
        ConfusionMatrixDumper.printGrayTable(cm, out);
        out.println("<p/>");
        ConfusionMatrixDumper.printCountsTable(cm, out);
        out.println("<p/>");
        ConfusionMatrixDumper.printTextInBox(cm, out);
        out.println("<p/>");
        if (wrapHtml) {
            ConfusionMatrixDumper.printFooter(out);
        }
    }

    private static List<String> stripDefault(ConfusionMatrix cm) {
        ArrayList stripped = Lists.newArrayList(cm.getLabels().iterator());
        String defaultLabel = cm.getDefaultLabel();
        int unclassified = cm.getTotal(defaultLabel);
        if (unclassified > 0) {
            return stripped;
        }
        stripped.remove(defaultLabel);
        return stripped;
    }

    private static void readSeqFile(Path path, Text key, MatrixWritable m) throws IOException {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, path, conf);
        reader.next((Writable)key, (Writable)m);
    }

    private static PrintStream getPrintStream(String outputFilename) throws IOException {
        if (outputFilename != null) {
            File outputFile = new File(outputFilename);
            if (outputFile.exists()) {
                outputFile.delete();
            }
            outputFile.createNewFile();
            FileOutputStream os = new FileOutputStream(outputFile);
            return new PrintStream((OutputStream)os, false, Charsets.UTF_8.displayName());
        }
        return System.out;
    }

    private static int getLabelTotal(ConfusionMatrix cm, String rowLabel) {
        Iterator iter = cm.getLabels().iterator();
        int count = 0;
        while (iter.hasNext()) {
            count += cm.getCount(rowLabel, (String)iter.next());
        }
        return count;
    }

    private static void printTextInBox(ConfusionMatrix cm, PrintStream out) {
        out.println("<div style='width:90%;overflow:scroll;'>");
        out.println("<pre>");
        out.println(cm.toString());
        out.println("</pre>");
        out.println("</div>");
    }

    public static void printSummaryTable(ConfusionMatrix cm, PrintStream out) {
        ConfusionMatrixDumper.format("<table class='%s'>\n", out, CSS_TABLE);
        ConfusionMatrixDumper.format("<tr class='%s'>", out, CSS_LABEL);
        out.println("<td>Label</td><td>Total</td><td>Correct</td><td>%</td>");
        out.println("</tr>");
        List<String> labels = ConfusionMatrixDumper.stripDefault(cm);
        for (String label : labels) {
            ConfusionMatrixDumper.printSummaryRow(cm, out, label);
        }
        out.println("</table>");
    }

    private static void printSummaryRow(ConfusionMatrix cm, PrintStream out, String label) {
        ConfusionMatrixDumper.format("<tr class='%s'>", out, CSS_CELL);
        int correct = cm.getCorrect(label);
        double accuracy = cm.getAccuracy(label);
        int count = ConfusionMatrixDumper.getCount(cm, label);
        ConfusionMatrixDumper.format("<td class='%s'>%s</td><td>%d</td><td>%d</td><td>%d</td>", out, CSS_CELL, label, count, correct, (int)Math.round(accuracy));
        out.println("</tr>");
    }

    private static int getCount(ConfusionMatrix cm, String label) {
        int count = 0;
        for (String s : cm.getLabels()) {
            count += cm.getCount(label, s);
        }
        return count;
    }

    public static void printGrayTable(ConfusionMatrix cm, PrintStream out) {
        ConfusionMatrixDumper.format("<table class='%s'>\n", out, CSS_TABLE);
        ConfusionMatrixDumper.printCountsHeader(cm, out, true);
        ConfusionMatrixDumper.printGrayRows(cm, out);
        out.println("</table>");
    }

    private static void printGrayRows(ConfusionMatrix cm, PrintStream out) {
        List<String> labels = ConfusionMatrixDumper.stripDefault(cm);
        for (String label : labels) {
            ConfusionMatrixDumper.printGrayRow(cm, out, labels, label);
        }
    }

    private static void printGrayRow(ConfusionMatrix cm, PrintStream out, Iterable<String> labels, String rowLabel) {
        ConfusionMatrixDumper.format("<tr class='%s'>", out, CSS_LABEL);
        ConfusionMatrixDumper.format("<td>%s</td>", out, rowLabel);
        int total = ConfusionMatrixDumper.getLabelTotal(cm, rowLabel);
        for (String columnLabel : labels) {
            ConfusionMatrixDumper.printGrayCell(cm, out, total, rowLabel, columnLabel);
        }
        out.println("</tr>");
    }

    private static void printGrayCell(ConfusionMatrix cm, PrintStream out, int total, String rowLabel, String columnLabel) {
        int count = cm.getCount(rowLabel, columnLabel);
        if (count == 0) {
            out.format("<td class='%s'/>", CSS_EMPTY);
        } else {
            int rating = (int)((double)count / (double)total * 4.0);
            String css = CSS_GRAY_CELLS[rating];
            ConfusionMatrixDumper.format("<td class='%s' title='%s'>%s</td>", out, css, columnLabel, count);
        }
    }

    public static void printCountsTable(ConfusionMatrix cm, PrintStream out) {
        ConfusionMatrixDumper.format("<table class='%s'>\n", out, CSS_TABLE);
        ConfusionMatrixDumper.printCountsHeader(cm, out, false);
        ConfusionMatrixDumper.printCountsRows(cm, out);
        out.println("</table>");
    }

    private static void printCountsRows(ConfusionMatrix cm, PrintStream out) {
        List<String> labels = ConfusionMatrixDumper.stripDefault(cm);
        for (String label : labels) {
            ConfusionMatrixDumper.printCountsRow(cm, out, labels, label);
        }
    }

    private static void printCountsRow(ConfusionMatrix cm, PrintStream out, Iterable<String> labels, String rowLabel) {
        out.println("<tr>");
        ConfusionMatrixDumper.format("<td class='%s'>%s</td>", out, CSS_LABEL, rowLabel);
        for (String columnLabel : labels) {
            ConfusionMatrixDumper.printCountsCell(cm, out, rowLabel, columnLabel);
        }
        out.println("</tr>");
    }

    private static void printCountsCell(ConfusionMatrix cm, PrintStream out, String rowLabel, String columnLabel) {
        int count = cm.getCount(rowLabel, columnLabel);
        String s = count == 0 ? "" : Integer.toString(count);
        ConfusionMatrixDumper.format("<td class='%s' title='%s'>%s</td>", out, CSS_CELL, columnLabel, s);
    }

    private static void printCountsHeader(ConfusionMatrix cm, PrintStream out, boolean vertical) {
        List<String> labels = ConfusionMatrixDumper.stripDefault(cm);
        int longest = ConfusionMatrixDumper.getLongestHeader(labels);
        if (vertical) {
            out.format("<tr class='%s' style='height:%dem'><th>&nbsp;</th>%n", CSS_TALL_HEADER, longest / 2);
            for (String label : labels) {
                out.format("<th><div class='%s'>%s</div></th>", CSS_VERTICAL, label);
            }
            out.println("</tr>");
        } else {
            out.format("<tr class='%s'><td class='%s'></td>%n", CSS_TABLE, CSS_LABEL);
            for (String label : labels) {
                out.format("<td>%s</td>", label);
            }
            out.format("</tr>", new Object[0]);
        }
    }

    private static int getLongestHeader(Iterable<String> labels) {
        int max = 0;
        for (String label : labels) {
            max = Math.max(label.length(), max);
        }
        return max;
    }

    private static void format(String format, PrintStream out, Object ... args) {
        String format2 = String.format(format, args);
        out.println(format2);
    }

    public static void printHeader(PrintStream out, CharSequence title) {
        out.println(HEADER.replace("TITLE", title));
    }

    public static void printFooter(PrintStream out) {
        out.println(FOOTER);
    }
}

