/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model;

import org.apache.mahout.cf.taste.impl.common.AbstractLongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;

final class PlusAnonymousUserLongPrimitiveIterator
extends AbstractLongPrimitiveIterator {
    private final LongPrimitiveIterator delegate;
    private final long extraDatum;
    private boolean datumConsumed;

    PlusAnonymousUserLongPrimitiveIterator(LongPrimitiveIterator delegate, long extraDatum) {
        this.delegate = delegate;
        this.extraDatum = extraDatum;
        this.datumConsumed = false;
    }

    @Override
    public long nextLong() {
        if (this.datumConsumed) {
            return this.delegate.nextLong();
        }
        if (this.delegate.hasNext()) {
            long delegateNext = this.delegate.peek();
            if (this.extraDatum <= delegateNext) {
                this.datumConsumed = true;
                return this.extraDatum;
            }
            return (Long)this.delegate.next();
        }
        this.datumConsumed = true;
        return this.extraDatum;
    }

    @Override
    public long peek() {
        if (this.datumConsumed) {
            return this.delegate.peek();
        }
        if (this.delegate.hasNext()) {
            long delegateNext = this.delegate.peek();
            if (this.extraDatum <= delegateNext) {
                return this.extraDatum;
            }
            return delegateNext;
        }
        return this.extraDatum;
    }

    @Override
    public boolean hasNext() {
        return !this.datumConsumed || this.delegate.hasNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void skip(int n) {
        for (int i = 0; i < n; ++i) {
            this.nextLong();
        }
    }
}

