/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClientScanner;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.client.ScannerCallableWithReplicas;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class ClientSmallScanner
extends ClientScanner {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private ScannerCallableWithReplicas smallScanCallable = null;
    private byte[] skipRowOfFirstResult = null;

    public ClientSmallScanner(Configuration conf, Scan scan, TableName tableName, ClusterConnection connection, RpcRetryingCallerFactory rpcFactory, RpcControllerFactory controllerFactory, ExecutorService pool, int primaryOperationTimeout) throws IOException {
        super(conf, scan, tableName, connection, rpcFactory, controllerFactory, pool, primaryOperationTimeout);
    }

    @Override
    protected void initializeScannerInConstruction() throws IOException {
    }

    private boolean nextScanner(int nbRows, boolean done, boolean currentRegionDone) throws IOException {
        byte[] localStartKey;
        int cacheNum = nbRows;
        this.skipRowOfFirstResult = null;
        if (this.currentRegion != null && currentRegionDone) {
            byte[] endKey = this.currentRegion.getEndKey();
            if (endKey == null || Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_BYTE_ARRAY) || this.checkScanStopRow(endKey) || done) {
                this.close();
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("Finished with small scan at " + this.currentRegion));
                }
                return false;
            }
            localStartKey = endKey;
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Finished with region " + this.currentRegion));
            }
        } else if (this.lastResult != null) {
            localStartKey = this.lastResult.getRow();
            this.skipRowOfFirstResult = this.lastResult.getRow();
            ++cacheNum;
        } else {
            localStartKey = this.scan.getStartRow();
        }
        if (this.LOG.isTraceEnabled()) {
            this.LOG.trace((Object)("Advancing internal small scanner to startKey at '" + Bytes.toStringBinary((byte[])localStartKey) + "'"));
        }
        this.smallScanCallable = ClientSmallScanner.getSmallScanCallable(this.getConnection(), this.getTable(), this.scan, this.getScanMetrics(), localStartKey, cacheNum, this.rpcControllerFactory, this.getPool(), this.getPrimaryOperationTimeout(), this.getRetries(), this.getScannerTimeout(), this.getConf(), this.caller);
        if (this.scanMetrics != null && this.skipRowOfFirstResult == null) {
            this.scanMetrics.countOfRegions.incrementAndGet();
        }
        return true;
    }

    static ScannerCallableWithReplicas getSmallScanCallable(ClusterConnection connection, TableName table, Scan scan, ScanMetrics scanMetrics, byte[] localStartKey, int cacheNum, RpcControllerFactory controllerFactory, ExecutorService pool, int primaryOperationTimeout, int retries, int scannerTimeout, Configuration conf, RpcRetryingCaller<Result[]> caller) {
        scan.setStartRow(localStartKey);
        SmallScannerCallable s = new SmallScannerCallable(connection, table, scan, scanMetrics, controllerFactory, cacheNum, 0);
        ScannerCallableWithReplicas scannerCallableWithReplicas = new ScannerCallableWithReplicas(table, connection, s, pool, primaryOperationTimeout, scan, retries, scannerTimeout, cacheNum, conf, caller);
        return scannerCallableWithReplicas;
    }

    @Override
    public Result next() throws IOException {
        if (this.cache.size() == 0 && this.closed) {
            return null;
        }
        if (this.cache.size() == 0) {
            Result[] values = null;
            long remainingResultSize = this.maxScannerResultSize;
            int countdown = this.caching;
            boolean currentRegionDone = false;
            while (remainingResultSize > 0L && countdown > 0 && this.nextScanner(countdown, values == null, currentRegionDone)) {
                values = this.caller.callWithoutRetries(this.smallScanCallable, this.scannerTimeout);
                this.currentRegion = this.smallScanCallable.getHRegionInfo();
                long currentTime = System.currentTimeMillis();
                if (this.scanMetrics != null) {
                    this.scanMetrics.sumOfMillisSecBetweenNexts.addAndGet(currentTime - this.lastNext);
                }
                this.lastNext = currentTime;
                if (values != null && values.length > 0) {
                    for (int i = 0; i < values.length; ++i) {
                        Result rs = values[i];
                        if (i == 0 && this.skipRowOfFirstResult != null && Bytes.equals((byte[])this.skipRowOfFirstResult, (byte[])rs.getRow())) continue;
                        this.cache.add(rs);
                        for (Cell cell : rs.rawCells()) {
                            remainingResultSize -= CellUtil.estimatedHeapSizeOf((Cell)cell);
                        }
                        --countdown;
                        this.lastResult = rs;
                    }
                }
                currentRegionDone = countdown > 0;
            }
        }
        if (this.cache.size() > 0) {
            return (Result)this.cache.poll();
        }
        this.writeScanMetrics();
        return null;
    }

    @Override
    public void close() {
        if (!this.scanMetricsPublished) {
            this.writeScanMetrics();
        }
        this.closed = true;
    }

    static class SmallScannerCallable
    extends ScannerCallable {
        public SmallScannerCallable(ClusterConnection connection, TableName table, Scan scan, ScanMetrics scanMetrics, RpcControllerFactory controllerFactory, int caching, int id) {
            super(connection, table, scan, scanMetrics, controllerFactory, id);
            this.setCaching(caching);
        }

        @Override
        public Result[] call(int timeout) throws IOException {
            if (this.closed) {
                return null;
            }
            if (Thread.interrupted()) {
                throw new InterruptedIOException();
            }
            ClientProtos.ScanRequest request = RequestConverter.buildScanRequest(this.getLocation().getRegionInfo().getRegionName(), this.getScan(), this.getCaching(), true);
            ClientProtos.ScanResponse response = null;
            PayloadCarryingRpcController controller = this.controllerFactory.newController();
            try {
                controller.setPriority(this.getTableName());
                controller.setCallTimeout(timeout);
                response = this.getStub().scan((RpcController)controller, request);
                return ResponseConverter.getResults(controller.cellScanner(), response);
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
        }

        @Override
        public ScannerCallable getScannerCallableForReplica(int id) {
            return new SmallScannerCallable((ClusterConnection)this.connection, this.tableName, this.getScan(), this.scanMetrics, this.controllerFactory, this.getCaching(), id);
        }
    }
}

