/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.nio.IntBuffer;
import java.util.Arrays;
import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.ByteByteProcedure;
import org.apache.mahout.math.function.ByteProcedure;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.set.AbstractSet;
import org.apache.mahout.math.set.HashUtils;

public abstract class AbstractByteByteMap
extends AbstractSet {
    public boolean containsKey(final byte key) {
        return !this.forEachKey(new ByteProcedure(){

            @Override
            public boolean apply(byte iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final byte value) {
        return !this.forEachPair(new ByteByteProcedure(){

            @Override
            public boolean apply(byte iterKey, byte iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractByteByteMap copy() {
        return (AbstractByteByteMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractByteByteMap)) {
            return false;
        }
        final AbstractByteByteMap other = (AbstractByteByteMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new ByteByteProcedure(){

            @Override
            public boolean apply(byte key, byte value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new ByteByteProcedure(){

            @Override
            public boolean apply(byte key, byte value) {
                return AbstractByteByteMap.this.containsKey(key) && AbstractByteByteMap.this.get(key) == value;
            }
        });
    }

    public int hashCode() {
        final int[] buf = new int[this.size()];
        this.forEachPair(new ByteByteProcedure(){
            int i = 0;

            @Override
            public boolean apply(byte key, byte value) {
                buf[this.i++] = HashUtils.hash(key) ^ HashUtils.hash(value);
                return true;
            }
        });
        Arrays.sort(buf);
        return IntBuffer.wrap(buf).hashCode();
    }

    public abstract boolean forEachKey(ByteProcedure var1);

    public boolean forEachPair(final ByteByteProcedure procedure) {
        return this.forEachKey(new ByteProcedure(){

            @Override
            public boolean apply(byte key) {
                return procedure.apply(key, AbstractByteByteMap.this.get(key));
            }
        });
    }

    public abstract byte get(byte var1);

    public ByteArrayList keys() {
        ByteArrayList list = new ByteArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final ByteArrayList list) {
        list.clear();
        this.forEachKey(new ByteProcedure(){

            @Override
            public boolean apply(byte key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(ByteArrayList keyList) {
        this.pairsSortedByValue(keyList, new ByteArrayList(this.size()));
    }

    public void pairsMatching(final ByteByteProcedure condition, final ByteArrayList keyList, final ByteArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new ByteByteProcedure(){

            @Override
            public boolean apply(byte key, byte value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(ByteArrayList keyList, ByteArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(ByteArrayList keyList, ByteArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final byte[] k = keyList.elements();
        final byte[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                byte t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                byte t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(byte var1, byte var2);

    public abstract boolean removeKey(byte var1);

    public String toString() {
        ByteArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            byte key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        ByteArrayList theKeys = new ByteArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            byte key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public ByteArrayList values() {
        ByteArrayList list = new ByteArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final ByteArrayList list) {
        list.clear();
        this.forEachKey(new ByteProcedure(){

            @Override
            public boolean apply(byte key) {
                list.add(AbstractByteByteMap.this.get(key));
                return true;
            }
        });
    }

    public byte adjustOrPutValue(byte key, byte newValue, byte incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = (byte)(this.get(key) + incrValue);
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

