/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.syntheticcontrol.canopy;

import java.util.Map;
import org.apache.commons.cli2.Option;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.clustering.canopy.CanopyDriver;
import org.apache.mahout.clustering.conversion.InputDriver;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.ClassUtils;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.EuclideanDistanceMeasure;
import org.apache.mahout.utils.clustering.ClusterDumper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class Job
extends AbstractJob {
    private static final String DIRECTORY_CONTAINING_CONVERTED_INPUT = "data";
    private static final Logger log = LoggerFactory.getLogger(Job.class);

    private Job() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            log.info("Running with only user-supplied arguments");
            ToolRunner.run((Configuration)new Configuration(), (Tool)new Job(), (String[])args);
        } else {
            log.info("Running with default arguments");
            Path output = new Path("output");
            HadoopUtil.delete((Configuration)new Configuration(), (Path[])new Path[]{output});
            Job.run(new Path("testdata"), output, (DistanceMeasure)new EuclideanDistanceMeasure(), 80.0, 55.0);
        }
    }

    private static void run(Path input, Path output, DistanceMeasure measure, double t1, double t2) throws Exception {
        Path directoryContainingConvertedInput = new Path(output, DIRECTORY_CONTAINING_CONVERTED_INPUT);
        InputDriver.runJob((Path)input, (Path)directoryContainingConvertedInput, (String)"org.apache.mahout.math.RandomAccessSparseVector");
        CanopyDriver.run((Configuration)new Configuration(), (Path)directoryContainingConvertedInput, (Path)output, (DistanceMeasure)measure, (double)t1, (double)t2, (boolean)true, (double)0.0, (boolean)false);
        ClusterDumper clusterDumper = new ClusterDumper(new Path(output, "clusters-0-final"), new Path(output, "clusteredPoints"));
        clusterDumper.printClusters(null);
    }

    public int run(String[] args) throws Exception {
        this.addInputOption();
        this.addOutputOption();
        this.addOption((Option)DefaultOptionCreator.distanceMeasureOption().create());
        this.addOption((Option)DefaultOptionCreator.t1Option().create());
        this.addOption((Option)DefaultOptionCreator.t2Option().create());
        this.addOption((Option)DefaultOptionCreator.overwriteOption().create());
        Map argMap = this.parseArguments(args);
        if (argMap == null) {
            return -1;
        }
        Path input = this.getInputPath();
        Path output = this.getOutputPath();
        if (this.hasOption("overwrite")) {
            HadoopUtil.delete((Configuration)new Configuration(), (Path[])new Path[]{output});
        }
        String measureClass = this.getOption("distanceMeasure");
        double t1 = Double.parseDouble(this.getOption("t1"));
        double t2 = Double.parseDouble(this.getOption("t2"));
        DistanceMeasure measure = (DistanceMeasure)ClassUtils.instantiateAs((String)measureClass, DistanceMeasure.class);
        Job.run(input, output, measure, t1, t2);
        return 0;
    }
}

