/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.benchmark;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.lang3.StringUtils;
import org.apache.mahout.benchmark.BenchmarkRunner;
import org.apache.mahout.benchmark.CloneBenchmark;
import org.apache.mahout.benchmark.ClosestCentroidBenchmark;
import org.apache.mahout.benchmark.DistanceBenchmark;
import org.apache.mahout.benchmark.DotBenchmark;
import org.apache.mahout.benchmark.MinusBenchmark;
import org.apache.mahout.benchmark.PlusBenchmark;
import org.apache.mahout.benchmark.SerializationBenchmark;
import org.apache.mahout.benchmark.TimesBenchmark;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.TimingStatistics;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.common.distance.ChebyshevDistanceMeasure;
import org.apache.mahout.common.distance.CosineDistanceMeasure;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.EuclideanDistanceMeasure;
import org.apache.mahout.common.distance.ManhattanDistanceMeasure;
import org.apache.mahout.common.distance.MinkowskiDistanceMeasure;
import org.apache.mahout.common.distance.SquaredEuclideanDistanceMeasure;
import org.apache.mahout.common.distance.TanimotoDistanceMeasure;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorBenchmarks {
    private static final int MAX_TIME_MS = 5000;
    private static final int LEAD_TIME_MS = 15000;
    public static final String CLUSTERS = "Clusters";
    public static final String CREATE_INCREMENTALLY = "Create (incrementally)";
    public static final String CREATE_COPY = "Create (copy)";
    public static final String DENSE_FN_SEQ = "Dense.fn(Seq)";
    public static final String RAND_FN_DENSE = "Rand.fn(Dense)";
    public static final String SEQ_FN_RAND = "Seq.fn(Rand)";
    public static final String RAND_FN_SEQ = "Rand.fn(Seq)";
    public static final String SEQ_FN_DENSE = "Seq.fn(Dense)";
    public static final String DENSE_FN_RAND = "Dense.fn(Rand)";
    public static final String SEQ_SPARSE_VECTOR = "SeqSparseVector";
    public static final String RAND_SPARSE_VECTOR = "RandSparseVector";
    public static final String DENSE_VECTOR = "DenseVector";
    private static final Logger log = LoggerFactory.getLogger(VectorBenchmarks.class);
    private static final Pattern TAB_NEWLINE_PATTERN = Pattern.compile("[\n\t]");
    private static final String[] EMPTY = new String[0];
    private static final DecimalFormat DF = new DecimalFormat("#.##");
    final Vector[][] vectors;
    final Vector[] clusters;
    final int cardinality;
    final int numNonZeros;
    final int numVectors;
    final int numClusters;
    final int loop = Integer.MAX_VALUE;
    final int opsPerUnit;
    final long maxTimeUsec;
    final long leadTimeUsec;
    private final List<Vector> randomVectors = new ArrayList<Vector>();
    private final List<int[]> randomVectorIndices = new ArrayList<int[]>();
    private final List<double[]> randomVectorValues = new ArrayList<double[]>();
    private final Map<String, Integer> implType = new HashMap<String, Integer>();
    private final Map<String, List<String[]>> statsMap = new HashMap<String, List<String[]>>();
    private final BenchmarkRunner runner;
    private final Random r = RandomUtils.getRandom();

    public VectorBenchmarks(int cardinality, int numNonZeros, int numVectors, int numClusters, int opsPerUnit) {
        this.runner = new BenchmarkRunner(15000L, 5000L);
        this.maxTimeUsec = TimeUnit.MILLISECONDS.toNanos(5000L);
        this.leadTimeUsec = TimeUnit.MILLISECONDS.toNanos(15000L);
        this.cardinality = cardinality;
        this.numNonZeros = numNonZeros;
        this.numVectors = numVectors;
        this.numClusters = numClusters;
        this.opsPerUnit = opsPerUnit;
        this.setUpVectors(cardinality, numNonZeros, numVectors);
        this.vectors = new Vector[3][numVectors];
        this.clusters = new Vector[numClusters];
    }

    private void setUpVectors(int cardinality, int numNonZeros, int numVectors) {
        for (int i = 0; i < numVectors; ++i) {
            SequentialAccessSparseVector v = new SequentialAccessSparseVector(cardinality, numNonZeros);
            BitSet featureSpace = new BitSet(cardinality);
            int[] indexes = new int[numNonZeros];
            double[] values = new double[numNonZeros];
            int j = 0;
            while (j < numNonZeros) {
                double value = this.r.nextGaussian();
                int index = this.r.nextInt(cardinality);
                if (featureSpace.get(index) || value == 0.0) continue;
                featureSpace.set(index);
                indexes[j] = index;
                values[j++] = value;
                v.set(index, value);
            }
            this.randomVectorIndices.add(indexes);
            this.randomVectorValues.add(values);
            this.randomVectors.add((Vector)v);
        }
    }

    void printStats(TimingStatistics stats, String benchmarkName, String implName, String content) {
        this.printStats(stats, benchmarkName, implName, content, 1);
    }

    void printStats(TimingStatistics stats, String benchmarkName, String implName) {
        this.printStats(stats, benchmarkName, implName, "", 1);
    }

    private void printStats(TimingStatistics stats, String benchmarkName, String implName, String content, int multiplier) {
        float speed = (float)(multiplier * stats.getNCalls()) * ((float)this.numNonZeros * 1000.0f * 12.0f / (float)stats.getSumTime());
        float opsPerSec = (float)stats.getNCalls() * 1.0E9f / (float)stats.getSumTime();
        log.info("{} {} \n{} {} \nOps    = {} Units/sec\nIOps   = {} MBytes/sec", new Object[]{benchmarkName, implName, content, stats.toString(), DF.format(opsPerSec), DF.format(speed)});
        if (!this.implType.containsKey(implName)) {
            this.implType.put(implName, this.implType.size());
        }
        int implId = this.implType.get(implName);
        if (!this.statsMap.containsKey(benchmarkName)) {
            this.statsMap.put(benchmarkName, new ArrayList());
        }
        List<String[]> implStats = this.statsMap.get(benchmarkName);
        while (implStats.size() < implId + 1) {
            implStats.add(EMPTY);
        }
        implStats.set(implId, TAB_NEWLINE_PATTERN.split(stats + "\tSpeed  = " + DF.format(opsPerSec) + " /sec\tRate   = " + DF.format(speed) + " MB/s"));
    }

    public void createData() {
        for (int i = 0; i < Math.max(this.numVectors, this.numClusters); ++i) {
            this.vectors[0][this.vIndex((int)i)] = new DenseVector(this.randomVectors.get(this.vIndex(i)));
            this.vectors[1][this.vIndex((int)i)] = new RandomAccessSparseVector(this.randomVectors.get(this.vIndex(i)));
            this.vectors[2][this.vIndex((int)i)] = new SequentialAccessSparseVector(this.randomVectors.get(this.vIndex(i)));
            if (this.numClusters <= 0) continue;
            this.clusters[this.cIndex((int)i)] = new RandomAccessSparseVector(this.randomVectors.get(this.vIndex(i)));
        }
    }

    public void createBenchmark() {
        this.printStats(this.runner.benchmark(new BenchmarkRunner.BenchmarkFn(){

            public Boolean apply(Integer i) {
                VectorBenchmarks.this.vectors[0][VectorBenchmarks.this.vIndex((int)i.intValue())] = new DenseVector((Vector)VectorBenchmarks.this.randomVectors.get(VectorBenchmarks.this.vIndex(i)));
                return this.depends(VectorBenchmarks.this.vectors[0][VectorBenchmarks.this.vIndex(i)]);
            }
        }), CREATE_COPY, DENSE_VECTOR);
        this.printStats(this.runner.benchmark(new BenchmarkRunner.BenchmarkFn(){

            public Boolean apply(Integer i) {
                VectorBenchmarks.this.vectors[1][VectorBenchmarks.this.vIndex((int)i.intValue())] = new RandomAccessSparseVector((Vector)VectorBenchmarks.this.randomVectors.get(VectorBenchmarks.this.vIndex(i)));
                return this.depends(VectorBenchmarks.this.vectors[1][VectorBenchmarks.this.vIndex(i)]);
            }
        }), CREATE_COPY, RAND_SPARSE_VECTOR);
        this.printStats(this.runner.benchmark(new BenchmarkRunner.BenchmarkFn(){

            public Boolean apply(Integer i) {
                VectorBenchmarks.this.vectors[2][VectorBenchmarks.this.vIndex((int)i.intValue())] = new SequentialAccessSparseVector((Vector)VectorBenchmarks.this.randomVectors.get(VectorBenchmarks.this.vIndex(i)));
                return this.depends(VectorBenchmarks.this.vectors[2][VectorBenchmarks.this.vIndex(i)]);
            }
        }), CREATE_COPY, SEQ_SPARSE_VECTOR);
        if (this.numClusters > 0) {
            this.printStats(this.runner.benchmark(new BenchmarkRunner.BenchmarkFn(){

                public Boolean apply(Integer i) {
                    VectorBenchmarks.this.clusters[VectorBenchmarks.this.cIndex((int)i.intValue())] = new RandomAccessSparseVector((Vector)VectorBenchmarks.this.randomVectors.get(VectorBenchmarks.this.vIndex(i)));
                    return this.depends(VectorBenchmarks.this.clusters[VectorBenchmarks.this.cIndex(i)]);
                }
            }), CREATE_COPY, CLUSTERS);
        }
    }

    private boolean buildVectorIncrementally(TimingStatistics stats, int randomIndex, Vector v, boolean useSetQuick) {
        int[] indexes = this.randomVectorIndices.get(randomIndex);
        double[] values = this.randomVectorValues.get(randomIndex);
        ArrayList<Integer> randomOrder = new ArrayList<Integer>();
        for (int i = 0; i < indexes.length; ++i) {
            randomOrder.add(i);
        }
        Collections.shuffle(randomOrder);
        int[] permutation = new int[randomOrder.size()];
        for (int i = 0; i < randomOrder.size(); ++i) {
            permutation[i] = (Integer)randomOrder.get(i);
        }
        TimingStatistics.Call call = stats.newCall(this.leadTimeUsec);
        if (useSetQuick) {
            for (int i : permutation) {
                v.setQuick(indexes[i], values[i]);
            }
        } else {
            for (int i : permutation) {
                v.set(indexes[i], values[i]);
            }
        }
        return call.end(this.maxTimeUsec);
    }

    public void incrementalCreateBenchmark() {
        int i;
        TimingStatistics stats = new TimingStatistics();
        for (i = 0; i < Integer.MAX_VALUE; ++i) {
            this.vectors[0][this.vIndex((int)i)] = new DenseVector(this.cardinality);
            if (this.buildVectorIncrementally(stats, this.vIndex(i), this.vectors[0][this.vIndex(i)], false)) break;
        }
        this.printStats(stats, CREATE_INCREMENTALLY, DENSE_VECTOR);
        stats = new TimingStatistics();
        for (i = 0; i < Integer.MAX_VALUE; ++i) {
            this.vectors[1][this.vIndex((int)i)] = new RandomAccessSparseVector(this.cardinality);
            if (this.buildVectorIncrementally(stats, this.vIndex(i), this.vectors[1][this.vIndex(i)], false)) break;
        }
        this.printStats(stats, CREATE_INCREMENTALLY, RAND_SPARSE_VECTOR);
        stats = new TimingStatistics();
        for (i = 0; i < Integer.MAX_VALUE; ++i) {
            this.vectors[2][this.vIndex((int)i)] = new SequentialAccessSparseVector(this.cardinality);
            if (this.buildVectorIncrementally(stats, this.vIndex(i), this.vectors[2][this.vIndex(i)], false)) break;
        }
        this.printStats(stats, CREATE_INCREMENTALLY, SEQ_SPARSE_VECTOR);
        if (this.numClusters > 0) {
            stats = new TimingStatistics();
            for (i = 0; i < Integer.MAX_VALUE; ++i) {
                this.clusters[this.cIndex((int)i)] = new RandomAccessSparseVector(this.cardinality);
                if (this.buildVectorIncrementally(stats, this.vIndex(i), this.clusters[this.cIndex(i)], false)) break;
            }
            this.printStats(stats, CREATE_INCREMENTALLY, CLUSTERS);
        }
    }

    public int vIndex(int i) {
        return i % this.numVectors;
    }

    public int cIndex(int i) {
        return i % this.numClusters;
    }

    public static void main(String[] args) throws IOException {
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption vectorSizeOpt = obuilder.withLongName("vectorSize").withRequired(false).withArgument(abuilder.withName("vs").withDefault((Object)1000000).create()).withDescription("Cardinality of the vector. Default: 1000000").withShortName("vs").create();
        DefaultOption numNonZeroOpt = obuilder.withLongName("numNonZero").withRequired(false).withArgument(abuilder.withName("nz").withDefault((Object)1000).create()).withDescription("Size of the vector. Default: 1000").withShortName("nz").create();
        DefaultOption numVectorsOpt = obuilder.withLongName("numVectors").withRequired(false).withArgument(abuilder.withName("nv").withDefault((Object)25).create()).withDescription("Number of Vectors to create. Default: 25").withShortName("nv").create();
        DefaultOption numClustersOpt = obuilder.withLongName("numClusters").withRequired(false).withArgument(abuilder.withName("nc").withDefault((Object)0).create()).withDescription("Number of clusters to create. Set to non zero to run cluster benchmark. Default: 0").withShortName("nc").create();
        DefaultOption numOpsOpt = obuilder.withLongName("numOps").withRequired(false).withArgument(abuilder.withName("numOps").withDefault((Object)10).create()).withDescription("Number of operations to do per timer. E.g In distance measure, the distance is calculated numOps times and the total time is measured. Default: 10").withShortName("no").create();
        Option helpOpt = DefaultOptionCreator.helpOption();
        Group group = gbuilder.withName("Options").withOption((Option)vectorSizeOpt).withOption((Option)numNonZeroOpt).withOption((Option)numVectorsOpt).withOption((Option)numOpsOpt).withOption((Option)numClustersOpt).withOption(helpOpt).create();
        try {
            Parser parser = new Parser();
            parser.setGroup(group);
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption(helpOpt)) {
                CommandLineUtil.printHelpWithGenericOptions((Group)group);
                return;
            }
            int cardinality = 1000000;
            if (cmdLine.hasOption((Option)vectorSizeOpt)) {
                cardinality = Integer.parseInt((String)cmdLine.getValue((Option)vectorSizeOpt));
            }
            int numClusters = 0;
            if (cmdLine.hasOption((Option)numClustersOpt)) {
                numClusters = Integer.parseInt((String)cmdLine.getValue((Option)numClustersOpt));
            }
            int numNonZero = 1000;
            if (cmdLine.hasOption((Option)numNonZeroOpt)) {
                numNonZero = Integer.parseInt((String)cmdLine.getValue((Option)numNonZeroOpt));
            }
            int numVectors = 25;
            if (cmdLine.hasOption((Option)numVectorsOpt)) {
                numVectors = Integer.parseInt((String)cmdLine.getValue((Option)numVectorsOpt));
            }
            int numOps = 10;
            if (cmdLine.hasOption((Option)numOpsOpt)) {
                numOps = Integer.parseInt((String)cmdLine.getValue((Option)numOpsOpt));
            }
            VectorBenchmarks mark = new VectorBenchmarks(cardinality, numNonZero, numVectors, numClusters, numOps);
            VectorBenchmarks.runBenchmark(mark);
            log.info("\n{}", (Object)mark.asCsvString());
        }
        catch (OptionException e) {
            CommandLineUtil.printHelp((Group)group);
        }
    }

    private static void runBenchmark(VectorBenchmarks mark) throws IOException {
        mark.createData();
        mark.createBenchmark();
        if (mark.cardinality < 200000) {
            mark.incrementalCreateBenchmark();
        }
        new CloneBenchmark(mark).benchmark();
        new DotBenchmark(mark).benchmark();
        new PlusBenchmark(mark).benchmark();
        new MinusBenchmark(mark).benchmark();
        new TimesBenchmark(mark).benchmark();
        new SerializationBenchmark(mark).benchmark();
        DistanceBenchmark distanceBenchmark = new DistanceBenchmark(mark);
        distanceBenchmark.benchmark((DistanceMeasure)new CosineDistanceMeasure());
        distanceBenchmark.benchmark((DistanceMeasure)new SquaredEuclideanDistanceMeasure());
        distanceBenchmark.benchmark((DistanceMeasure)new EuclideanDistanceMeasure());
        distanceBenchmark.benchmark((DistanceMeasure)new ManhattanDistanceMeasure());
        distanceBenchmark.benchmark((DistanceMeasure)new TanimotoDistanceMeasure());
        distanceBenchmark.benchmark((DistanceMeasure)new ChebyshevDistanceMeasure());
        distanceBenchmark.benchmark((DistanceMeasure)new MinkowskiDistanceMeasure());
        if (mark.numClusters > 0) {
            ClosestCentroidBenchmark centroidBenchmark = new ClosestCentroidBenchmark(mark);
            centroidBenchmark.benchmark((DistanceMeasure)new CosineDistanceMeasure());
            centroidBenchmark.benchmark((DistanceMeasure)new SquaredEuclideanDistanceMeasure());
            centroidBenchmark.benchmark((DistanceMeasure)new EuclideanDistanceMeasure());
            centroidBenchmark.benchmark((DistanceMeasure)new ManhattanDistanceMeasure());
            centroidBenchmark.benchmark((DistanceMeasure)new TanimotoDistanceMeasure());
            centroidBenchmark.benchmark((DistanceMeasure)new ChebyshevDistanceMeasure());
            centroidBenchmark.benchmark((DistanceMeasure)new MinkowskiDistanceMeasure());
        }
    }

    private String asCsvString() {
        ArrayList<String> keys = new ArrayList<String>(this.statsMap.keySet());
        Collections.sort(keys);
        HashMap<Integer, String> implMap = new HashMap<Integer, String>();
        for (Map.Entry<String, Integer> e : this.implType.entrySet()) {
            implMap.put(e.getValue(), e.getKey());
        }
        StringBuilder sb = new StringBuilder(1000);
        for (String benchmarkName : keys) {
            int i = 0;
            for (String[] stats : this.statsMap.get(benchmarkName)) {
                if (stats.length < 8) continue;
                sb.append(benchmarkName).append(',');
                sb.append((String)implMap.get(i++)).append(',');
                sb.append(stats[7].trim().split("=|/")[1].trim());
                sb.append('\n');
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    public String toString() {
        int pad = 24;
        StringBuilder sb = new StringBuilder(1000);
        sb.append(StringUtils.rightPad((String)"BenchMarks", (int)pad));
        block0: for (int i = 0; i < this.implType.size(); ++i) {
            for (Map.Entry<String, Integer> e : this.implType.entrySet()) {
                if (e.getValue() != i) continue;
                sb.append(StringUtils.rightPad((String)e.getKey(), (int)pad).substring(0, pad));
                continue block0;
            }
        }
        sb.append('\n');
        ArrayList<String> keys = new ArrayList<String>(this.statsMap.keySet());
        Collections.sort(keys);
        for (String benchmarkName : keys) {
            List<String[]> implTokenizedStats = this.statsMap.get(benchmarkName);
            int maxStats = 0;
            for (String[] stat : implTokenizedStats) {
                maxStats = Math.max(maxStats, stat.length);
            }
            for (int i = 0; i < maxStats; ++i) {
                boolean printedName = false;
                for (String[] stats : implTokenizedStats) {
                    if (i == 0 && !printedName) {
                        sb.append(StringUtils.rightPad((String)benchmarkName, (int)pad));
                        printedName = true;
                    } else if (!printedName) {
                        printedName = true;
                        sb.append(StringUtils.rightPad((String)"", (int)pad));
                    }
                    if (stats.length > i) {
                        sb.append(StringUtils.rightPad((String)stats[i], (int)pad));
                        continue;
                    }
                    sb.append(StringUtils.rightPad((String)"", (int)pad));
                }
                sb.append('\n');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public BenchmarkRunner getRunner() {
        return this.runner;
    }
}

