/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.h2obindings.drm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixWritable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.drm.BCast;

public class H2OBCast<T>
implements BCast<T>,
Serializable {
    private transient T obj;
    private byte[] buf;
    private boolean isMatrix;

    public H2OBCast(T o) {
        this.obj = o;
        if (o instanceof Matrix) {
            this.buf = this.serialize((Writable)new MatrixWritable((Matrix)o));
            this.isMatrix = true;
        } else if (o instanceof Vector) {
            this.buf = this.serialize((Writable)new VectorWritable((Vector)o));
            this.isMatrix = false;
        } else {
            throw new IllegalArgumentException("Only Matrix or Vector supported for now");
        }
    }

    public T value() {
        if (this.obj == null) {
            this.obj = this.deserialize(this.buf);
        }
        return this.obj;
    }

    private byte[] serialize(Writable w) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            w.write((DataOutput)oos);
            oos.close();
        }
        catch (IOException e) {
            return null;
        }
        return bos.toByteArray();
    }

    private T deserialize(byte[] buf) {
        Matrix ret = null;
        try (ByteArrayInputStream bis = new ByteArrayInputStream(buf);){
            ObjectInputStream ois = new ObjectInputStream(bis);
            if (this.isMatrix) {
                MatrixWritable w = new MatrixWritable();
                w.readFields((DataInput)ois);
                ret = w.get();
            } else {
                VectorWritable w = new VectorWritable();
                w.readFields((DataInput)ois);
                ret = w.get();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (T)ret;
    }

    public void close() throws IOException {
    }
}

