/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.model.GenericItemPreferenceArray;
import org.apache.mahout.cf.taste.impl.model.PlusAnonymousUserLongPrimitiveIterator;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlusAnonymousUserDataModel
implements DataModel {
    public static final long TEMP_USER_ID = Long.MIN_VALUE;
    private final DataModel delegate;
    private PreferenceArray tempPrefs;
    private final FastIDSet prefItemIDs;
    private static final Logger log = LoggerFactory.getLogger(PlusAnonymousUserDataModel.class);

    public PlusAnonymousUserDataModel(DataModel delegate) {
        this.delegate = delegate;
        this.prefItemIDs = new FastIDSet();
    }

    protected DataModel getDelegate() {
        return this.delegate;
    }

    public void setTempPrefs(PreferenceArray prefs) {
        Preconditions.checkArgument((prefs != null && prefs.length() > 0 ? 1 : 0) != 0, (Object)"prefs is null or empty");
        this.tempPrefs = prefs;
        this.prefItemIDs.clear();
        for (int i = 0; i < prefs.length(); ++i) {
            this.prefItemIDs.add(prefs.getItemID(i));
        }
    }

    public void clearTempPrefs() {
        this.tempPrefs = null;
        this.prefItemIDs.clear();
    }

    @Override
    public LongPrimitiveIterator getUserIDs() throws TasteException {
        if (this.tempPrefs == null) {
            return this.delegate.getUserIDs();
        }
        return new PlusAnonymousUserLongPrimitiveIterator(this.delegate.getUserIDs(), Long.MIN_VALUE);
    }

    @Override
    public PreferenceArray getPreferencesFromUser(long userID) throws TasteException {
        if (userID == Long.MIN_VALUE) {
            if (this.tempPrefs == null) {
                throw new NoSuchUserException(Long.MIN_VALUE);
            }
            return this.tempPrefs;
        }
        return this.delegate.getPreferencesFromUser(userID);
    }

    @Override
    public FastIDSet getItemIDsFromUser(long userID) throws TasteException {
        if (userID == Long.MIN_VALUE) {
            if (this.tempPrefs == null) {
                throw new NoSuchUserException(Long.MIN_VALUE);
            }
            return this.prefItemIDs;
        }
        return this.delegate.getItemIDsFromUser(userID);
    }

    @Override
    public LongPrimitiveIterator getItemIDs() throws TasteException {
        return this.delegate.getItemIDs();
    }

    @Override
    public PreferenceArray getPreferencesForItem(long itemID) throws TasteException {
        PreferenceArray delegatePrefs;
        block5: {
            if (this.tempPrefs == null) {
                return this.delegate.getPreferencesForItem(itemID);
            }
            delegatePrefs = null;
            try {
                delegatePrefs = this.delegate.getPreferencesForItem(itemID);
            }
            catch (NoSuchItemException nsie) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("Item {} unknown", (Object)itemID);
            }
        }
        for (int i = 0; i < this.tempPrefs.length(); ++i) {
            if (this.tempPrefs.getItemID(i) != itemID) continue;
            return PlusAnonymousUserDataModel.cloneAndMergeInto(delegatePrefs, itemID, this.tempPrefs.getUserID(i), this.tempPrefs.getValue(i));
        }
        if (delegatePrefs == null) {
            throw new NoSuchItemException(itemID);
        }
        return delegatePrefs;
    }

    private static PreferenceArray cloneAndMergeInto(PreferenceArray delegatePrefs, long itemID, long newUserID, float value) {
        int i;
        int positionToInsert;
        int length = delegatePrefs == null ? 0 : delegatePrefs.length();
        int newLength = length + 1;
        GenericItemPreferenceArray newPreferenceArray = new GenericItemPreferenceArray(newLength);
        newPreferenceArray.setItemID(0, itemID);
        for (positionToInsert = 0; positionToInsert < length && newUserID > delegatePrefs.getUserID(positionToInsert); ++positionToInsert) {
        }
        for (i = 0; i < positionToInsert; ++i) {
            newPreferenceArray.setUserID(i, delegatePrefs.getUserID(i));
            newPreferenceArray.setValue(i, delegatePrefs.getValue(i));
        }
        newPreferenceArray.setUserID(positionToInsert, newUserID);
        newPreferenceArray.setValue(positionToInsert, value);
        for (i = positionToInsert + 1; i < newLength; ++i) {
            newPreferenceArray.setUserID(i, delegatePrefs.getUserID(i - 1));
            newPreferenceArray.setValue(i, delegatePrefs.getValue(i - 1));
        }
        return newPreferenceArray;
    }

    @Override
    public Float getPreferenceValue(long userID, long itemID) throws TasteException {
        if (userID == Long.MIN_VALUE) {
            if (this.tempPrefs == null) {
                throw new NoSuchUserException(Long.MIN_VALUE);
            }
            for (int i = 0; i < this.tempPrefs.length(); ++i) {
                if (this.tempPrefs.getItemID(i) != itemID) continue;
                return Float.valueOf(this.tempPrefs.getValue(i));
            }
            return null;
        }
        return this.delegate.getPreferenceValue(userID, itemID);
    }

    @Override
    public Long getPreferenceTime(long userID, long itemID) throws TasteException {
        if (userID == Long.MIN_VALUE) {
            if (this.tempPrefs == null) {
                throw new NoSuchUserException(Long.MIN_VALUE);
            }
            return null;
        }
        return this.delegate.getPreferenceTime(userID, itemID);
    }

    @Override
    public int getNumItems() throws TasteException {
        return this.delegate.getNumItems();
    }

    @Override
    public int getNumUsers() throws TasteException {
        return this.delegate.getNumUsers() + (this.tempPrefs == null ? 0 : 1);
    }

    @Override
    public int getNumUsersWithPreferenceFor(long itemID) throws TasteException {
        if (this.tempPrefs == null) {
            return this.delegate.getNumUsersWithPreferenceFor(itemID);
        }
        boolean found = false;
        for (int i = 0; i < this.tempPrefs.length(); ++i) {
            if (this.tempPrefs.getItemID(i) != itemID) continue;
            found = true;
            break;
        }
        return this.delegate.getNumUsersWithPreferenceFor(itemID) + (found ? 1 : 0);
    }

    @Override
    public int getNumUsersWithPreferenceFor(long itemID1, long itemID2) throws TasteException {
        if (this.tempPrefs == null) {
            return this.delegate.getNumUsersWithPreferenceFor(itemID1, itemID2);
        }
        boolean found1 = false;
        boolean found2 = false;
        for (int i = 0; !(i >= this.tempPrefs.length() || found1 && found2); ++i) {
            long itemID = this.tempPrefs.getItemID(i);
            if (itemID == itemID1) {
                found1 = true;
            }
            if (itemID != itemID2) continue;
            found2 = true;
        }
        return this.delegate.getNumUsersWithPreferenceFor(itemID1, itemID2) + (found1 && found2 ? 1 : 0);
    }

    @Override
    public void setPreference(long userID, long itemID, float value) throws TasteException {
        if (userID == Long.MIN_VALUE) {
            if (this.tempPrefs == null) {
                throw new NoSuchUserException(Long.MIN_VALUE);
            }
            throw new UnsupportedOperationException();
        }
        this.delegate.setPreference(userID, itemID, value);
    }

    @Override
    public void removePreference(long userID, long itemID) throws TasteException {
        if (userID == Long.MIN_VALUE) {
            if (this.tempPrefs == null) {
                throw new NoSuchUserException(Long.MIN_VALUE);
            }
            throw new UnsupportedOperationException();
        }
        this.delegate.removePreference(userID, itemID);
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.delegate.refresh(alreadyRefreshed);
    }

    @Override
    public boolean hasPreferenceValues() {
        return this.delegate.hasPreferenceValues();
    }

    @Override
    public float getMaxPreference() {
        return this.delegate.getMaxPreference();
    }

    @Override
    public float getMinPreference() {
        return this.delegate.getMinPreference();
    }
}

