/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.kddcup.track1;

import java.io.File;
import java.io.IOException;
import org.apache.commons.cli2.OptionException;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.example.TasteOptionParser;
import org.apache.mahout.cf.taste.example.kddcup.KDDCupDataModel;
import org.apache.mahout.cf.taste.example.kddcup.track1.Track1RecommenderBuilder;
import org.apache.mahout.cf.taste.example.kddcup.track1.Track1RecommenderEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Track1RecommenderEvaluatorRunner {
    private static final Logger log = LoggerFactory.getLogger(Track1RecommenderEvaluatorRunner.class);

    private Track1RecommenderEvaluatorRunner() {
    }

    public static void main(String ... args) throws IOException, TasteException, OptionException {
        File dataFileDirectory = TasteOptionParser.getRatings(args);
        if (dataFileDirectory == null) {
            throw new IllegalArgumentException("No data directory");
        }
        if (!dataFileDirectory.exists() || !dataFileDirectory.isDirectory()) {
            throw new IllegalArgumentException("Bad data file directory: " + dataFileDirectory);
        }
        Track1RecommenderEvaluator evaluator = new Track1RecommenderEvaluator(dataFileDirectory);
        KDDCupDataModel model = new KDDCupDataModel(KDDCupDataModel.getTrainingFile(dataFileDirectory));
        double evaluation = evaluator.evaluate(new Track1RecommenderBuilder(), null, model, Double.NaN, Double.NaN);
        log.info(String.valueOf(evaluation));
    }
}

