/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import org.apache.lucene.facet.params.CategoryListParams;
import org.apache.lucene.facet.search.CategoryListIterator;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetsAggregator;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.search.OrdinalValueResolver;
import org.apache.lucene.util.IntsRef;

public class SumScoreFacetsAggregator
implements FacetsAggregator {
    private final IntsRef ordinals = new IntsRef(32);

    @Override
    public void aggregate(FacetsCollector.MatchingDocs matchingDocs, CategoryListParams clp, FacetArrays facetArrays) throws IOException {
        CategoryListIterator cli = clp.createCategoryListIterator(0);
        if (!cli.setNextReader(matchingDocs.context)) {
            return;
        }
        int length = matchingDocs.bits.length();
        float[] scores = facetArrays.getFloatArray();
        int scoresIdx = 0;
        for (int doc = 0; doc < length && (doc = matchingDocs.bits.nextSetBit(doc)) != -1; ++doc) {
            cli.getOrdinals(doc, this.ordinals);
            int upto = this.ordinals.offset + this.ordinals.length;
            float score = matchingDocs.scores[scoresIdx++];
            for (int i = this.ordinals.offset; i < upto; ++i) {
                int n = this.ordinals.ints[i];
                scores[n] = scores[n] + score;
            }
        }
    }

    private float rollupScores(int ordinal, int[] children, int[] siblings, float[] scores) {
        float score = 0.0f;
        while (ordinal != -1) {
            float childScore = scores[ordinal];
            scores[ordinal] = childScore += this.rollupScores(children[ordinal], children, siblings, scores);
            score += childScore;
            ordinal = siblings[ordinal];
        }
        return score;
    }

    @Override
    public void rollupValues(FacetRequest fr, int ordinal, int[] children, int[] siblings, FacetArrays facetArrays) {
        float[] scores = facetArrays.getFloatArray();
        int n = ordinal;
        scores[n] = scores[n] + this.rollupScores(children[ordinal], children, siblings, scores);
    }

    @Override
    public boolean requiresDocScores() {
        return true;
    }

    @Override
    public OrdinalValueResolver createOrdinalValueResolver(FacetRequest facetRequest, FacetArrays arrays) {
        return new OrdinalValueResolver.FloatValueResolver(arrays);
    }
}

