/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import org.apache.lucene.facet.params.CategoryListParams;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetsAggregator;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.search.OrdinalValueResolver;

public abstract class IntRollupFacetsAggregator
implements FacetsAggregator {
    @Override
    public abstract void aggregate(FacetsCollector.MatchingDocs var1, CategoryListParams var2, FacetArrays var3) throws IOException;

    private int rollupValues(int ordinal, int[] children, int[] siblings, int[] values) {
        int value = 0;
        while (ordinal != -1) {
            int childValue = values[ordinal];
            values[ordinal] = childValue += this.rollupValues(children[ordinal], children, siblings, values);
            value += childValue;
            ordinal = siblings[ordinal];
        }
        return value;
    }

    @Override
    public final void rollupValues(FacetRequest fr, int ordinal, int[] children, int[] siblings, FacetArrays facetArrays) {
        int[] values = facetArrays.getIntArray();
        int n = ordinal;
        values[n] = values[n] + this.rollupValues(children[ordinal], children, siblings, values);
    }

    @Override
    public final boolean requiresDocScores() {
        return false;
    }

    @Override
    public OrdinalValueResolver createOrdinalValueResolver(FacetRequest facetRequest, FacetArrays arrays) {
        return new OrdinalValueResolver.IntValueResolver(arrays);
    }
}

