/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model.jdbc;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.Cache;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.Retriever;
import org.apache.mahout.cf.taste.impl.common.jdbc.AbstractJDBCComponent;
import org.apache.mahout.cf.taste.impl.common.jdbc.ResultSetIterator;
import org.apache.mahout.cf.taste.impl.model.GenericItemPreferenceArray;
import org.apache.mahout.cf.taste.impl.model.GenericPreference;
import org.apache.mahout.cf.taste.impl.model.GenericUserPreferenceArray;
import org.apache.mahout.cf.taste.impl.model.jdbc.ConnectionPoolDataSource;
import org.apache.mahout.cf.taste.model.JDBCDataModel;
import org.apache.mahout.cf.taste.model.Preference;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.common.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJDBCDataModel
extends AbstractJDBCComponent
implements JDBCDataModel {
    private static final Logger log = LoggerFactory.getLogger(AbstractJDBCDataModel.class);
    public static final String DEFAULT_PREFERENCE_TABLE = "taste_preferences";
    public static final String DEFAULT_USER_ID_COLUMN = "user_id";
    public static final String DEFAULT_ITEM_ID_COLUMN = "item_id";
    public static final String DEFAULT_PREFERENCE_COLUMN = "preference";
    public static final String DEFAULT_PREFERENCE_TIME_COLUMN = "timestamp";
    private final DataSource dataSource;
    private final String preferenceTable;
    private final String userIDColumn;
    private final String itemIDColumn;
    private final String preferenceColumn;
    private final String getPreferenceSQL;
    private final String getPreferenceTimeSQL;
    private final String getUserSQL;
    private final String getAllUsersSQL;
    private final String getNumItemsSQL;
    private final String getNumUsersSQL;
    private final String setPreferenceSQL;
    private final String removePreferenceSQL;
    private final String getUsersSQL;
    private final String getItemsSQL;
    private final String getPrefsForItemSQL;
    private final String getNumPreferenceForItemsSQL;
    private final String getMaxPreferenceSQL;
    private final String getMinPreferenceSQL;
    private int cachedNumUsers;
    private int cachedNumItems;
    private final Cache<Long, Integer> itemPrefCounts;
    private float maxPreference;
    private float minPreference;

    protected AbstractJDBCDataModel(DataSource dataSource, String getPreferenceSQL, String getPreferenceTimeSQL, String getUserSQL, String getAllUsersSQL, String getNumItemsSQL, String getNumUsersSQL, String setPreferenceSQL, String removePreferenceSQL, String getUsersSQL, String getItemsSQL, String getPrefsForItemSQL, String getNumPreferenceForItemSQL, String getNumPreferenceForItemsSQL, String getMaxPreferenceSQL, String getMinPreferenceSQL) {
        this(dataSource, DEFAULT_PREFERENCE_TABLE, DEFAULT_USER_ID_COLUMN, DEFAULT_ITEM_ID_COLUMN, DEFAULT_PREFERENCE_COLUMN, getPreferenceSQL, getPreferenceTimeSQL, getUserSQL, getAllUsersSQL, getNumItemsSQL, getNumUsersSQL, setPreferenceSQL, removePreferenceSQL, getUsersSQL, getItemsSQL, getPrefsForItemSQL, getNumPreferenceForItemSQL, getNumPreferenceForItemsSQL, getMaxPreferenceSQL, getMinPreferenceSQL);
    }

    protected AbstractJDBCDataModel(DataSource dataSource, String preferenceTable, String userIDColumn, String itemIDColumn, String preferenceColumn, String getPreferenceSQL, String getPreferenceTimeSQL, String getUserSQL, String getAllUsersSQL, String getNumItemsSQL, String getNumUsersSQL, String setPreferenceSQL, String removePreferenceSQL, String getUsersSQL, String getItemsSQL, String getPrefsForItemSQL, String getNumPreferenceForItemSQL, String getNumPreferenceForItemsSQL, String getMaxPreferenceSQL, String getMinPreferenceSQL) {
        log.debug("Creating AbstractJDBCModel...");
        AbstractJDBCComponent.checkNotNullAndLog((String)"preferenceTable", (Object)preferenceTable);
        AbstractJDBCComponent.checkNotNullAndLog((String)"userIDColumn", (Object)userIDColumn);
        AbstractJDBCComponent.checkNotNullAndLog((String)"itemIDColumn", (Object)itemIDColumn);
        AbstractJDBCComponent.checkNotNullAndLog((String)"preferenceColumn", (Object)preferenceColumn);
        AbstractJDBCComponent.checkNotNullAndLog((String)"dataSource", (Object)dataSource);
        AbstractJDBCComponent.checkNotNullAndLog((String)"getUserSQL", (Object)getUserSQL);
        AbstractJDBCComponent.checkNotNullAndLog((String)"getAllUsersSQL", (Object)getAllUsersSQL);
        AbstractJDBCComponent.checkNotNullAndLog((String)"getPreferenceSQL", (Object)getPreferenceSQL);
        AbstractJDBCComponent.checkNotNullAndLog((String)"getNumItemsSQL", (Object)getNumItemsSQL);
        AbstractJDBCComponent.checkNotNullAndLog((String)"getNumUsersSQL", (Object)getNumUsersSQL);
        AbstractJDBCComponent.checkNotNullAndLog((String)"setPreferenceSQL", (Object)setPreferenceSQL);
        AbstractJDBCComponent.checkNotNullAndLog((String)"removePreferenceSQL", (Object)removePreferenceSQL);
        AbstractJDBCComponent.checkNotNullAndLog((String)"getUsersSQL", (Object)getUsersSQL);
        AbstractJDBCComponent.checkNotNullAndLog((String)"getItemsSQL", (Object)getItemsSQL);
        AbstractJDBCComponent.checkNotNullAndLog((String)"getPrefsForItemSQL", (Object)getPrefsForItemSQL);
        AbstractJDBCComponent.checkNotNullAndLog((String)"getNumPreferenceForItemSQL", (Object)getNumPreferenceForItemSQL);
        AbstractJDBCComponent.checkNotNullAndLog((String)"getNumPreferenceForItemsSQL", (Object)getNumPreferenceForItemsSQL);
        AbstractJDBCComponent.checkNotNullAndLog((String)"getMaxPreferenceSQL", (Object)getMaxPreferenceSQL);
        AbstractJDBCComponent.checkNotNullAndLog((String)"getMinPreferenceSQL", (Object)getMinPreferenceSQL);
        if (!(dataSource instanceof ConnectionPoolDataSource)) {
            log.warn("You are not using ConnectionPoolDataSource. Make sure your DataSource pools connections to the database itself, or database performance will be severely reduced.");
        }
        this.preferenceTable = preferenceTable;
        this.userIDColumn = userIDColumn;
        this.itemIDColumn = itemIDColumn;
        this.preferenceColumn = preferenceColumn;
        this.dataSource = dataSource;
        this.getPreferenceSQL = getPreferenceSQL;
        this.getPreferenceTimeSQL = getPreferenceTimeSQL;
        this.getUserSQL = getUserSQL;
        this.getAllUsersSQL = getAllUsersSQL;
        this.getNumItemsSQL = getNumItemsSQL;
        this.getNumUsersSQL = getNumUsersSQL;
        this.setPreferenceSQL = setPreferenceSQL;
        this.removePreferenceSQL = removePreferenceSQL;
        this.getUsersSQL = getUsersSQL;
        this.getItemsSQL = getItemsSQL;
        this.getPrefsForItemSQL = getPrefsForItemSQL;
        this.getNumPreferenceForItemsSQL = getNumPreferenceForItemsSQL;
        this.getMaxPreferenceSQL = getMaxPreferenceSQL;
        this.getMinPreferenceSQL = getMinPreferenceSQL;
        this.cachedNumUsers = -1;
        this.cachedNumItems = -1;
        this.itemPrefCounts = new Cache((Retriever)new ItemPrefCountRetriever(getNumPreferenceForItemSQL));
        this.maxPreference = Float.NaN;
        this.minPreference = Float.NaN;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String getPreferenceTable() {
        return this.preferenceTable;
    }

    public String getUserIDColumn() {
        return this.userIDColumn;
    }

    public String getItemIDColumn() {
        return this.itemIDColumn;
    }

    public String getPreferenceColumn() {
        return this.preferenceColumn;
    }

    String getSetPreferenceSQL() {
        return this.setPreferenceSQL;
    }

    public LongPrimitiveIterator getUserIDs() throws TasteException {
        log.debug("Retrieving all users...");
        try {
            return new ResultSetIDIterator(this.getUsersSQL);
        }
        catch (SQLException sqle) {
            throw new TasteException((Throwable)sqle);
        }
    }

    public PreferenceArray getPreferencesFromUser(long userID) throws TasteException {
        GenericUserPreferenceArray genericUserPreferenceArray;
        log.debug("Retrieving user ID '{}'", (Object)userID);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.getUserSQL, 1003, 1007);
            stmt.setFetchDirection(1000);
            stmt.setFetchSize(this.getFetchSize());
            this.setLongParameter(stmt, 1, userID);
            log.debug("Executing SQL query: {}", (Object)this.getUserSQL);
            rs = stmt.executeQuery();
            ArrayList<Preference> prefs = new ArrayList<Preference>();
            while (rs.next()) {
                prefs.add(this.buildPreference(rs));
            }
            if (prefs.isEmpty()) {
                throw new NoSuchUserException(userID);
            }
            genericUserPreferenceArray = new GenericUserPreferenceArray(prefs);
        }
        catch (SQLException sqle) {
            try {
                log.warn("Exception while retrieving user", (Throwable)sqle);
                throw new TasteException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        IOUtils.quietClose((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return genericUserPreferenceArray;
    }

    public FastByIDMap<PreferenceArray> exportWithPrefs() throws TasteException {
        FastByIDMap fastByIDMap;
        log.debug("Exporting all data");
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        FastByIDMap result = new FastByIDMap();
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.createStatement(1003, 1007);
            stmt.setFetchDirection(1000);
            stmt.setFetchSize(this.getFetchSize());
            log.debug("Executing SQL query: {}", (Object)this.getAllUsersSQL);
            rs = stmt.executeQuery(this.getAllUsersSQL);
            Long currentUserID = null;
            ArrayList<Preference> currentPrefs = new ArrayList<Preference>();
            while (rs.next()) {
                long nextUserID = this.getLongColumn(rs, 1);
                if (currentUserID != null && !currentUserID.equals(nextUserID) && !currentPrefs.isEmpty()) {
                    result.put(currentUserID.longValue(), (Object)new GenericUserPreferenceArray(currentPrefs));
                    currentPrefs.clear();
                }
                currentPrefs.add(this.buildPreference(rs));
                currentUserID = nextUserID;
            }
            if (!currentPrefs.isEmpty()) {
                result.put(currentUserID.longValue(), (Object)new GenericUserPreferenceArray(currentPrefs));
            }
            fastByIDMap = result;
        }
        catch (SQLException sqle) {
            try {
                log.warn("Exception while exporting all data", (Throwable)sqle);
                throw new TasteException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        IOUtils.quietClose((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return fastByIDMap;
    }

    public FastByIDMap<FastIDSet> exportWithIDsOnly() throws TasteException {
        FastByIDMap fastByIDMap;
        log.debug("Exporting all data");
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        FastByIDMap result = new FastByIDMap();
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.createStatement(1003, 1007);
            stmt.setFetchDirection(1000);
            stmt.setFetchSize(this.getFetchSize());
            log.debug("Executing SQL query: {}", (Object)this.getAllUsersSQL);
            rs = stmt.executeQuery(this.getAllUsersSQL);
            boolean currentUserIDSet = false;
            long currentUserID = 0L;
            FastIDSet currentItemIDs = new FastIDSet(2);
            while (rs.next()) {
                long nextUserID = this.getLongColumn(rs, 1);
                if (currentUserIDSet && currentUserID != nextUserID && !currentItemIDs.isEmpty()) {
                    result.put(currentUserID, (Object)currentItemIDs);
                    currentItemIDs = new FastIDSet(2);
                }
                currentItemIDs.add(this.getLongColumn(rs, 2));
                currentUserID = nextUserID;
                currentUserIDSet = true;
            }
            if (!currentItemIDs.isEmpty()) {
                result.put(currentUserID, (Object)currentItemIDs);
            }
            fastByIDMap = result;
        }
        catch (SQLException sqle) {
            try {
                log.warn("Exception while exporting all data", (Throwable)sqle);
                throw new TasteException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        IOUtils.quietClose((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return fastByIDMap;
    }

    public FastIDSet getItemIDsFromUser(long userID) throws TasteException {
        FastIDSet fastIDSet;
        log.debug("Retrieving items for user ID '{}'", (Object)userID);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.getUserSQL, 1003, 1007);
            stmt.setFetchDirection(1000);
            stmt.setFetchSize(this.getFetchSize());
            this.setLongParameter(stmt, 1, userID);
            log.debug("Executing SQL query: {}", (Object)this.getUserSQL);
            rs = stmt.executeQuery();
            FastIDSet result = new FastIDSet();
            while (rs.next()) {
                result.add(this.getLongColumn(rs, 2));
            }
            if (result.isEmpty()) {
                throw new NoSuchUserException(userID);
            }
            fastIDSet = result;
        }
        catch (SQLException sqle) {
            try {
                log.warn("Exception while retrieving item s", (Throwable)sqle);
                throw new TasteException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        IOUtils.quietClose((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return fastIDSet;
    }

    public Float getPreferenceValue(long userID, long itemID) throws TasteException {
        Float f;
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block5: {
            log.debug("Retrieving preferences for item ID '{}'", (Object)itemID);
            conn = null;
            stmt = null;
            rs = null;
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.getPreferenceSQL, 1003, 1007);
            stmt.setFetchDirection(1000);
            stmt.setFetchSize(1);
            this.setLongParameter(stmt, 1, userID);
            this.setLongParameter(stmt, 2, itemID);
            log.debug("Executing SQL query: {}", (Object)this.getPreferenceSQL);
            rs = stmt.executeQuery();
            if (!rs.next()) break block5;
            Float f2 = Float.valueOf(rs.getFloat(1));
            IOUtils.quietClose((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return f2;
        }
        try {
            f = null;
        }
        catch (SQLException sqle) {
            try {
                log.warn("Exception while retrieving prefs for item", (Throwable)sqle);
                throw new TasteException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        IOUtils.quietClose((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return f;
    }

    public Long getPreferenceTime(long userID, long itemID) throws TasteException {
        Long l;
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block6: {
            if (this.getPreferenceTimeSQL == null) {
                return null;
            }
            log.debug("Retrieving preference time for item ID '{}'", (Object)itemID);
            conn = null;
            stmt = null;
            rs = null;
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.getPreferenceTimeSQL, 1003, 1007);
            stmt.setFetchDirection(1000);
            stmt.setFetchSize(1);
            this.setLongParameter(stmt, 1, userID);
            this.setLongParameter(stmt, 2, itemID);
            log.debug("Executing SQL query: {}", (Object)this.getPreferenceTimeSQL);
            rs = stmt.executeQuery();
            if (!rs.next()) break block6;
            Long l2 = rs.getLong(1);
            IOUtils.quietClose((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return l2;
        }
        try {
            l = null;
        }
        catch (SQLException sqle) {
            try {
                log.warn("Exception while retrieving time for item", (Throwable)sqle);
                throw new TasteException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        IOUtils.quietClose((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return l;
    }

    public LongPrimitiveIterator getItemIDs() throws TasteException {
        log.debug("Retrieving all items...");
        try {
            return new ResultSetIDIterator(this.getItemsSQL);
        }
        catch (SQLException sqle) {
            throw new TasteException((Throwable)sqle);
        }
    }

    public PreferenceArray getPreferencesForItem(long itemID) throws TasteException {
        List<Preference> list = this.doGetPreferencesForItem(itemID);
        if (list.isEmpty()) {
            throw new NoSuchItemException(itemID);
        }
        return new GenericItemPreferenceArray(list);
    }

    protected List<Preference> doGetPreferencesForItem(long itemID) throws TasteException {
        ArrayList<Preference> arrayList;
        log.debug("Retrieving preferences for item ID '{}'", (Object)itemID);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.getPrefsForItemSQL, 1003, 1007);
            stmt.setFetchDirection(1000);
            stmt.setFetchSize(this.getFetchSize());
            this.setLongParameter(stmt, 1, itemID);
            log.debug("Executing SQL query: {}", (Object)this.getPrefsForItemSQL);
            rs = stmt.executeQuery();
            ArrayList<Preference> prefs = new ArrayList<Preference>();
            while (rs.next()) {
                prefs.add(this.buildPreference(rs));
            }
            arrayList = prefs;
        }
        catch (SQLException sqle) {
            try {
                log.warn("Exception while retrieving prefs for item", (Throwable)sqle);
                throw new TasteException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        IOUtils.quietClose((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return arrayList;
    }

    public int getNumItems() throws TasteException {
        if (this.cachedNumItems < 0) {
            this.cachedNumItems = this.getNumThings("items", this.getNumItemsSQL, new long[0]);
        }
        return this.cachedNumItems;
    }

    public int getNumUsers() throws TasteException {
        if (this.cachedNumUsers < 0) {
            this.cachedNumUsers = this.getNumThings("users", this.getNumUsersSQL, new long[0]);
        }
        return this.cachedNumUsers;
    }

    public int getNumUsersWithPreferenceFor(long itemID) throws TasteException {
        return (Integer)this.itemPrefCounts.get((Object)itemID);
    }

    public int getNumUsersWithPreferenceFor(long itemID1, long itemID2) throws TasteException {
        return this.getNumThings("user preferring items", this.getNumPreferenceForItemsSQL, itemID1, itemID2);
    }

    private int getNumThings(String name, String sql, long ... args) throws TasteException {
        int i;
        log.debug("Retrieving number of {} in model", (Object)name);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(sql, 1003, 1007);
            stmt.setFetchDirection(1000);
            stmt.setFetchSize(this.getFetchSize());
            if (args != null) {
                for (i = 1; i <= args.length; ++i) {
                    this.setLongParameter(stmt, i, args[i - 1]);
                }
            }
            log.debug("Executing SQL query: {}", (Object)sql);
            rs = stmt.executeQuery();
            rs.next();
            i = rs.getInt(1);
        }
        catch (SQLException sqle) {
            try {
                log.warn("Exception while retrieving number of {}", (Object)name, (Object)sqle);
                throw new TasteException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        IOUtils.quietClose((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return i;
    }

    public void setPreference(long userID, long itemID, float value) throws TasteException {
        Preconditions.checkArgument((!Float.isNaN(value) ? 1 : 0) != 0, (Object)"NaN value");
        log.debug("Setting preference for user {}, item {}", (Object)userID, (Object)itemID);
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.setPreferenceSQL);
            this.setLongParameter(stmt, 1, userID);
            this.setLongParameter(stmt, 2, itemID);
            stmt.setDouble(3, value);
            stmt.setDouble(4, value);
            log.debug("Executing SQL update: {}", (Object)this.setPreferenceSQL);
            stmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                log.warn("Exception while setting preference", (Throwable)sqle);
                throw new TasteException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(null, stmt, (Connection)conn);
                throw throwable;
            }
        }
        IOUtils.quietClose(null, (Statement)stmt, (Connection)conn);
    }

    public void removePreference(long userID, long itemID) throws TasteException {
        log.debug("Removing preference for user '{}', item '{}'", (Object)userID, (Object)itemID);
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.removePreferenceSQL);
            this.setLongParameter(stmt, 1, userID);
            this.setLongParameter(stmt, 2, itemID);
            log.debug("Executing SQL update: {}", (Object)this.removePreferenceSQL);
            stmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                log.warn("Exception while removing preference", (Throwable)sqle);
                throw new TasteException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(null, stmt, (Connection)conn);
                throw throwable;
            }
        }
        IOUtils.quietClose(null, (Statement)stmt, (Connection)conn);
    }

    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.cachedNumUsers = -1;
        this.cachedNumItems = -1;
        this.minPreference = Float.NaN;
        this.maxPreference = Float.NaN;
        this.itemPrefCounts.clear();
    }

    public boolean hasPreferenceValues() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getMaxPreference() {
        if (Float.isNaN(this.maxPreference)) {
            Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                conn = this.dataSource.getConnection();
                stmt = conn.prepareStatement(this.getMaxPreferenceSQL);
                log.debug("Executing SQL query: {}", (Object)this.getMaxPreferenceSQL);
                rs = stmt.executeQuery();
                rs.next();
                this.maxPreference = rs.getFloat(1);
            }
            catch (SQLException sqle) {
                try {
                    log.warn("Exception while removing preference", (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    IOUtils.quietClose(rs, stmt, (Connection)conn);
                    throw throwable;
                }
                IOUtils.quietClose(rs, (Statement)stmt, (Connection)conn);
            }
            IOUtils.quietClose((ResultSet)rs, (Statement)stmt, (Connection)conn);
        }
        return this.maxPreference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getMinPreference() {
        if (Float.isNaN(this.minPreference)) {
            Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                conn = this.dataSource.getConnection();
                stmt = conn.prepareStatement(this.getMinPreferenceSQL);
                log.debug("Executing SQL query: {}", (Object)this.getMinPreferenceSQL);
                rs = stmt.executeQuery();
                rs.next();
                this.minPreference = rs.getFloat(1);
            }
            catch (SQLException sqle) {
                try {
                    log.warn("Exception while removing preference", (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    IOUtils.quietClose(rs, stmt, (Connection)conn);
                    throw throwable;
                }
                IOUtils.quietClose(rs, (Statement)stmt, (Connection)conn);
            }
            IOUtils.quietClose((ResultSet)rs, (Statement)stmt, (Connection)conn);
        }
        return this.minPreference;
    }

    protected Preference buildPreference(ResultSet rs) throws SQLException {
        return new GenericPreference(this.getLongColumn(rs, 1), this.getLongColumn(rs, 2), rs.getFloat(3));
    }

    protected long getLongColumn(ResultSet rs, int position) throws SQLException {
        return rs.getLong(position);
    }

    protected void setLongParameter(PreparedStatement stmt, int position, long value) throws SQLException {
        stmt.setLong(position, value);
    }

    private final class ItemPrefCountRetriever
    implements Retriever<Long, Integer> {
        private final String getNumPreferenceForItemSQL;

        private ItemPrefCountRetriever(String getNumPreferenceForItemSQL) {
            this.getNumPreferenceForItemSQL = getNumPreferenceForItemSQL;
        }

        public Integer get(Long key) throws TasteException {
            return AbstractJDBCDataModel.this.getNumThings("user preferring item", this.getNumPreferenceForItemSQL, new long[]{key});
        }
    }

    private final class ResultSetIDIterator
    extends ResultSetIterator<Long>
    implements LongPrimitiveIterator {
        private ResultSetIDIterator(String sql) throws SQLException {
            super(AbstractJDBCDataModel.this.dataSource, sql);
        }

        protected Long parseElement(ResultSet resultSet) throws SQLException {
            return AbstractJDBCDataModel.this.getLongColumn(resultSet, 1);
        }

        public long nextLong() {
            return (Long)this.next();
        }

        public long peek() {
            throw new UnsupportedOperationException();
        }
    }
}

