/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.mahout.classifier.df.data.DataUtils;
import org.apache.mahout.classifier.df.data.Dataset;
import org.apache.mahout.classifier.df.data.Instance;
import org.apache.mahout.classifier.df.data.conditions.Condition;

public class Data
implements Cloneable {
    private final List<Instance> instances;
    private final Dataset dataset;

    public Data(Dataset dataset) {
        this.dataset = dataset;
        this.instances = new ArrayList<Instance>();
    }

    public Data(Dataset dataset, List<Instance> instances) {
        this.dataset = dataset;
        this.instances = new ArrayList<Instance>(instances);
    }

    public int size() {
        return this.instances.size();
    }

    public boolean isEmpty() {
        return this.instances.isEmpty();
    }

    public boolean contains(Instance v) {
        return this.instances.contains(v);
    }

    public Instance get(int index) {
        return this.instances.get(index);
    }

    public Data subset(Condition condition) {
        ArrayList<Instance> subset = new ArrayList<Instance>();
        for (Instance instance : this.instances) {
            if (!condition.isTrueFor(instance)) continue;
            subset.add(instance);
        }
        return new Data(this.dataset, subset);
    }

    public Data bagging(Random rng) {
        int datasize = this.size();
        ArrayList<Instance> bag = new ArrayList<Instance>(datasize);
        for (int i = 0; i < datasize; ++i) {
            bag.add(this.instances.get(rng.nextInt(datasize)));
        }
        return new Data(this.dataset, bag);
    }

    public Data bagging(Random rng, boolean[] sampled) {
        int datasize = this.size();
        ArrayList<Instance> bag = new ArrayList<Instance>(datasize);
        for (int i = 0; i < datasize; ++i) {
            int index = rng.nextInt(datasize);
            bag.add(this.instances.get(index));
            sampled[index] = true;
        }
        return new Data(this.dataset, bag);
    }

    public Data rsplit(Random rng, int subsize) {
        ArrayList<Instance> subset = new ArrayList<Instance>(subsize);
        for (int i = 0; i < subsize; ++i) {
            subset.add(this.instances.remove(rng.nextInt(this.instances.size())));
        }
        return new Data(this.dataset, subset);
    }

    public boolean isIdentical() {
        if (this.isEmpty()) {
            return true;
        }
        Instance instance = this.get(0);
        for (int attr = 0; attr < this.dataset.nbAttributes(); ++attr) {
            for (int index = 1; index < this.size(); ++index) {
                if (this.get(index).get(attr) == instance.get(attr)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean identicalLabel() {
        if (this.isEmpty()) {
            return true;
        }
        double label = this.dataset.getLabel(this.get(0));
        for (int index = 1; index < this.size(); ++index) {
            if (this.dataset.getLabel(this.get(index)) == label) continue;
            return false;
        }
        return true;
    }

    public double[] values(int attr) {
        HashSet<Double> result = new HashSet<Double>();
        for (Instance instance : this.instances) {
            result.add(instance.get(attr));
        }
        double[] values = new double[result.size()];
        int index = 0;
        for (Double value : result) {
            values[index++] = value;
        }
        return values;
    }

    public Data clone() {
        return new Data(this.dataset, new ArrayList<Instance>(this.instances));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Data)) {
            return false;
        }
        Data data = (Data)obj;
        return this.instances.equals(data.instances) && this.dataset.equals(data.dataset);
    }

    public int hashCode() {
        return this.instances.hashCode() + this.dataset.hashCode();
    }

    public double[] extractLabels() {
        double[] labels = new double[this.size()];
        for (int index = 0; index < labels.length; ++index) {
            labels[index] = this.dataset.getLabel(this.get(index));
        }
        return labels;
    }

    public int majorityLabel(Random rng) {
        int[] counts = new int[this.dataset.nblabels()];
        for (int index = 0; index < this.size(); ++index) {
            int n = (int)this.dataset.getLabel(this.get(index));
            counts[n] = counts[n] + 1;
        }
        return DataUtils.maxindex(rng, counts);
    }

    public void countLabels(int[] counts) {
        for (int index = 0; index < this.size(); ++index) {
            int n = (int)this.dataset.getLabel(this.get(index));
            counts[n] = counts[n] + 1;
        }
    }

    public Dataset getDataset() {
        return this.dataset;
    }
}

