/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.IOContext;
import org.apache.mahout.text.LuceneIndexHelper;
import org.apache.mahout.text.LuceneSegmentInputSplit;
import org.apache.mahout.text.LuceneStorageConfiguration;

@Deprecated
public class LuceneSegmentRecordReader
extends RecordReader<Text, NullWritable> {
    public static final int USE_TERM_INFO = 1;
    private SegmentReader segmentReader;
    private Scorer scorer;
    private int nextDocId;
    private Text key = new Text();

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        LuceneSegmentInputSplit inputSplit = (LuceneSegmentInputSplit)split;
        Configuration configuration = context.getConfiguration();
        LuceneStorageConfiguration lucene2SeqConfiguration = new LuceneStorageConfiguration(configuration);
        SegmentCommitInfo segmentInfo = inputSplit.getSegment(configuration);
        this.segmentReader = new SegmentReader(segmentInfo, 1, IOContext.READ);
        IndexSearcher searcher = new IndexSearcher((IndexReader)this.segmentReader);
        String idField = lucene2SeqConfiguration.getIdField();
        LuceneIndexHelper.fieldShouldExistInIndex((IndexReader)this.segmentReader, idField);
        for (String field : lucene2SeqConfiguration.getFields()) {
            LuceneIndexHelper.fieldShouldExistInIndex((IndexReader)this.segmentReader, field);
        }
        Weight weight = lucene2SeqConfiguration.getQuery().createWeight(searcher);
        this.scorer = weight.scorer(this.segmentReader.getContext(), false, false, null);
        if (this.scorer == null) {
            throw new IllegalArgumentException("Could not create query scorer for query: " + lucene2SeqConfiguration.getQuery());
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        this.nextDocId = this.scorer.nextDoc();
        return this.nextDocId != Integer.MAX_VALUE;
    }

    public Text getCurrentKey() throws IOException, InterruptedException {
        this.key.set(String.valueOf(this.nextDocId));
        return this.key;
    }

    public NullWritable getCurrentValue() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.scorer.cost() == 0L ? 0.0f : (float)this.nextDocId / (float)this.scorer.cost();
    }

    public void close() throws IOException {
        this.segmentReader.close();
    }
}

