/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.NonNullableAccessors;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Static;

public class ArrayElementOperandTypeChecker
implements SqlOperandTypeChecker {
    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlNode op0 = callBinding.operand(0);
        if (!OperandTypes.ARRAY.checkSingleOperandType(callBinding, op0, 0, throwOnFailure)) {
            return false;
        }
        RelDataType arrayComponentType = NonNullableAccessors.getComponentTypeOrThrow(SqlTypeUtil.deriveType(callBinding, op0));
        SqlNode op1 = callBinding.operand(1);
        RelDataType aryType1 = SqlTypeUtil.deriveType(callBinding, op1);
        RelDataType biggest = callBinding.getTypeFactory().leastRestrictive((List<RelDataType>)ImmutableList.of((Object)arrayComponentType, (Object)aryType1));
        if (biggest == null) {
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.typeNotComparable(arrayComponentType.toString(), aryType1.toString()));
            }
            return false;
        }
        return true;
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        return "<ARRAY> " + opName + " <ARRAY>";
    }
}

