/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core.backup;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.backup.BackupFilePaths;
import org.apache.solr.core.backup.BackupId;
import org.apache.solr.core.backup.BackupProperties;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.util.FileTypeMagicUtil;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupManager {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String COLLECTION_PROPS_FILE = "collection_state.json";
    public static final String TRADITIONAL_BACKUP_PROPS_FILE = "backup.properties";
    public static final String ZK_STATE_DIR = "zk_backup";
    public static final String CONFIG_STATE_DIR = "configs";
    public static final String COLLECTION_NAME_PROP = "collection";
    public static final String COLLECTION_ALIAS_PROP = "collectionAlias";
    public static final String BACKUP_NAME_PROP = "backupName";
    public static final String INDEX_VERSION_PROP = "indexVersion";
    public static final String START_TIME_PROP = "startTime";
    protected final ZkStateReader zkStateReader;
    protected final BackupRepository repository;
    protected final BackupId backupId;
    protected final URI backupPath;
    protected final String existingPropsFile;

    private BackupManager(BackupRepository repository, URI backupPath, ZkStateReader zkStateReader, String existingPropsFile, BackupId backupId) {
        this.repository = Objects.requireNonNull(repository);
        this.backupPath = backupPath;
        this.zkStateReader = Objects.requireNonNull(zkStateReader);
        this.existingPropsFile = existingPropsFile;
        this.backupId = backupId;
    }

    public static BackupManager forIncrementalBackup(BackupRepository repository, ZkStateReader stateReader, URI backupPath) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(stateReader);
        Optional<BackupId> lastBackupId = BackupFilePaths.findMostRecentBackupIdFromFileListing(repository.listAllOrEmpty(backupPath));
        return new BackupManager(repository, backupPath, stateReader, lastBackupId.map(id -> BackupFilePaths.getBackupPropsName(id)).orElse(null), lastBackupId.map(BackupId::nextBackupId).orElse(BackupId.zero()));
    }

    public static BackupManager forBackup(BackupRepository repository, ZkStateReader stateReader, URI backupPath) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(stateReader);
        return new BackupManager(repository, backupPath, stateReader, null, BackupId.traditionalBackup());
    }

    public static BackupManager forRestore(BackupRepository repository, ZkStateReader stateReader, URI backupPath, int bid) throws IOException {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(stateReader);
        BackupId backupId = new BackupId(bid);
        String backupPropsName = BackupFilePaths.getBackupPropsName(backupId);
        if (!repository.exists(repository.resolve(backupPath, backupPropsName))) {
            throw new IllegalStateException("Backup id " + bid + " was not found");
        }
        return new BackupManager(repository, backupPath, stateReader, backupPropsName, backupId);
    }

    public static BackupManager forRestore(BackupRepository repository, ZkStateReader stateReader, URI backupPath) throws IOException {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(stateReader);
        if (!repository.exists(backupPath)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Couldn't restore since doesn't exist: " + backupPath);
        }
        Optional<BackupId> opFileGen = BackupFilePaths.findMostRecentBackupIdFromFileListing(repository.listAll(backupPath));
        if (opFileGen.isPresent()) {
            BackupId backupPropFile = opFileGen.get();
            return new BackupManager(repository, backupPath, stateReader, BackupFilePaths.getBackupPropsName(backupPropFile), backupPropFile);
        }
        if (repository.exists(repository.resolve(backupPath, TRADITIONAL_BACKUP_PROPS_FILE))) {
            return new BackupManager(repository, backupPath, stateReader, TRADITIONAL_BACKUP_PROPS_FILE, null);
        }
        throw new IllegalStateException("No backup.properties was found, the backup does not exist or not complete");
    }

    public final BackupId getBackupId() {
        return this.backupId;
    }

    public final String getVersion() {
        return "1.0";
    }

    public BackupProperties readBackupProperties() throws IOException {
        if (this.existingPropsFile == null) {
            throw new IllegalStateException("No backup.properties was found, the backup does not exist or not complete");
        }
        return BackupProperties.readFrom(this.repository, this.backupPath, this.existingPropsFile);
    }

    public Optional<BackupProperties> tryReadBackupProperties() throws IOException {
        if (this.existingPropsFile != null) {
            return Optional.of(BackupProperties.readFrom(this.repository, this.backupPath, this.existingPropsFile));
        }
        return Optional.empty();
    }

    public void writeBackupProperties(BackupProperties props) throws IOException {
        URI dest = this.repository.resolve(this.backupPath, BackupFilePaths.getBackupPropsName(this.backupId));
        try (OutputStreamWriter propsWriter = new OutputStreamWriter(this.repository.createOutput(dest), StandardCharsets.UTF_8);){
            props.store(propsWriter);
        }
    }

    public DocCollection readCollectionState(String collectionName) throws IOException {
        Objects.requireNonNull(collectionName);
        URI zkStateDir = this.getZkStateDir();
        try (IndexInput is = this.repository.openInput(zkStateDir, COLLECTION_PROPS_FILE, IOContext.DEFAULT);){
            byte[] arr = new byte[(int)is.length()];
            is.readBytes(arr, 0, (int)is.length());
            ClusterState c_state = ClusterState.load((Integer)-1, (byte[])arr, Collections.emptySet());
            DocCollection docCollection = c_state.getCollection(collectionName);
            return docCollection;
        }
    }

    public void writeCollectionState(String collectionName, DocCollection collectionState) throws IOException {
        URI dest = this.repository.resolve(this.getZkStateDir(), COLLECTION_PROPS_FILE);
        try (OutputStream collectionStateOs = this.repository.createOutput(dest);){
            collectionStateOs.write(Utils.toJSON(Collections.singletonMap(collectionName, collectionState)));
        }
    }

    public void uploadConfigDir(String sourceConfigName, String targetConfigName) throws IOException {
        URI source = this.repository.resolveDirectory(this.getZkStateDir(), CONFIG_STATE_DIR, sourceConfigName);
        Preconditions.checkState((boolean)this.repository.exists(source), (String)"Path {} does not exist", (Object)source);
        Preconditions.checkState((this.repository.getPathType(source) == BackupRepository.PathType.DIRECTORY ? 1 : 0) != 0, (String)"Path {} is not a directory", (Object)source);
        this.uploadToZk(this.zkStateReader.getZkClient(), source, "configs/" + targetConfigName);
    }

    public void downloadConfigDir(String configName) throws IOException {
        URI dest = this.repository.resolveDirectory(this.getZkStateDir(), CONFIG_STATE_DIR, configName);
        this.repository.createDirectory(this.getZkStateDir());
        this.repository.createDirectory(this.repository.resolveDirectory(this.getZkStateDir(), CONFIG_STATE_DIR));
        this.repository.createDirectory(dest);
        this.downloadFromZK(this.zkStateReader.getZkClient(), "/configs/" + configName, dest);
    }

    public void uploadCollectionProperties(String collectionName) throws IOException {
        URI sourceDir = this.getZkStateDir();
        URI source = this.repository.resolve(sourceDir, "collectionprops.json");
        if (!this.repository.exists(source)) {
            return;
        }
        String zkPath = "/collections/" + collectionName + '/' + "collectionprops.json";
        try (IndexInput is = this.repository.openInput(sourceDir, "collectionprops.json", IOContext.DEFAULT);){
            byte[] arr = new byte[(int)is.length()];
            is.readBytes(arr, 0, (int)is.length());
            this.zkStateReader.getZkClient().create(zkPath, arr, CreateMode.PERSISTENT, true);
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error uploading file to zookeeper path " + source.toString() + " to " + zkPath, SolrZkClient.checkInterrupted((Throwable)e));
        }
    }

    public void downloadCollectionProperties(String collectionName) throws IOException {
        URI dest = this.repository.resolve(this.getZkStateDir(), "collectionprops.json");
        String zkPath = "/collections/" + collectionName + '/' + "collectionprops.json";
        try {
            if (!this.zkStateReader.getZkClient().exists(zkPath, true).booleanValue()) {
                return;
            }
            try (OutputStream os = this.repository.createOutput(dest);){
                byte[] data = this.zkStateReader.getZkClient().getData(zkPath, null, null, true);
                os.write(data);
            }
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error downloading file from zookeeper path " + zkPath + " to " + dest.toString(), SolrZkClient.checkInterrupted((Throwable)e));
        }
    }

    private void downloadFromZK(SolrZkClient zkClient, String zkPath, URI dir) throws IOException {
        try {
            List files = zkClient.getChildren(zkPath, null, true);
            for (String file : files) {
                List children = zkClient.getChildren(zkPath + "/" + file, null, true);
                if (children.size() == 0) {
                    log.debug("Writing file {}", (Object)file);
                    byte[] data = zkClient.getData(zkPath + "/" + file, null, null, true);
                    if (!FileTypeMagicUtil.isFileForbiddenInConfigset(data)) {
                        OutputStream os = this.repository.createOutput(this.repository.resolve(dir, file));
                        Throwable throwable = null;
                        try {
                            os.write(data);
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (os == null) continue;
                            if (throwable != null) {
                                try {
                                    os.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            os.close();
                            continue;
                        }
                    }
                    String mimeType = FileTypeMagicUtil.INSTANCE.guessMimeType(data);
                    log.warn("Not including zookeeper file {} in backup, as it matched the MAGIC signature of a forbidden mime type {}", (Object)file, (Object)mimeType);
                    continue;
                }
                URI uri = this.repository.resolve(dir, file);
                if (!this.repository.exists(uri)) {
                    this.repository.createDirectory(uri);
                }
                this.downloadFromZK(zkClient, zkPath + "/" + file, this.repository.resolve(dir, file));
            }
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error downloading files from zookeeper path " + zkPath + " to " + dir.toString(), SolrZkClient.checkInterrupted((Throwable)e));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void uploadToZk(SolrZkClient zkClient, URI sourceDir, String destZkPath) throws IOException {
        block14: for (String file : this.repository.listAll(sourceDir)) {
            zkNodePath = destZkPath + "/" + file;
            path = this.repository.resolve(sourceDir, new String[]{file});
            t = this.repository.getPathType(path);
            switch (1.$SwitchMap$org$apache$solr$core$backup$repository$BackupRepository$PathType[t.ordinal()]) {
                case 1: {
                    try {
                        is = this.repository.openInput(sourceDir, file, IOContext.DEFAULT);
                        var12_13 = null;
                        arr = new byte[(int)is.length()];
                        is.readBytes(arr, 0, (int)is.length());
                        if (!FileTypeMagicUtil.isFileForbiddenInConfigset(arr)) {
                            zkClient.makePath(zkNodePath, arr, true);
                        } else {
                            mimeType = FileTypeMagicUtil.INSTANCE.guessMimeType(arr);
                            BackupManager.log.warn("Not restoring configset file {} to zookeeper, as it matched the MAGIC signature of a forbidden mime type {}", (Object)file, (Object)mimeType);
                        }
                        if (is == null) continue block14;
                        if (var12_13 == null) ** GOTO lbl26
                        try {
                            is.close();
                        }
                        catch (Throwable var13_15) {
                            var12_13.addSuppressed(var13_15);
                        }
                        continue block14;
lbl26:
                        // 1 sources

                        is.close();
                        ** break;
                        catch (Throwable var13_16) {
                            try {
                                var12_13 = var13_16;
                                throw var13_16;
                            }
                            catch (Throwable var15_18) {
                                if (is != null) {
                                    if (var12_13 != null) {
                                        try {
                                            is.close();
                                        }
                                        catch (Throwable var16_19) {
                                            var12_13.addSuppressed(var16_19);
                                        }
                                    } else {
                                        is.close();
                                    }
                                }
                                throw var15_18;
lbl43:
                                // 1 sources

                                continue block14;
                            }
                        }
                    }
                    catch (InterruptedException | KeeperException e) {
                        throw new IOException(SolrZkClient.checkInterrupted((Throwable)e));
                    }
                }
                case 2: {
                    if (file.startsWith(".")) continue block14;
                    this.uploadToZk(zkClient, path, zkNodePath);
                    continue block14;
                }
                default: {
                    throw new IllegalStateException("Unknown path type " + (Object)t);
                }
            }
        }
    }

    private URI getZkStateDir() {
        URI zkStateDir;
        if (this.backupId != null) {
            String zkBackupFolder = BackupFilePaths.getZkStateDir(this.backupId);
            zkStateDir = this.repository.resolveDirectory(this.backupPath, zkBackupFolder);
        } else {
            zkStateDir = this.repository.resolveDirectory(this.backupPath, ZK_STATE_DIR);
        }
        return zkStateDir;
    }
}

