/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InvokeOp
implements CoreAdminHandler.CoreAdminOp {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    InvokeOp() {
    }

    static Map<String, Object> invokeAClass(SolrQueryRequest req, String c) {
        SolrResourceLoader loader = null;
        if (req.getCore() != null) {
            loader = req.getCore().getResourceLoader();
        } else if (req.getContext().get(CoreContainer.class.getName()) != null) {
            CoreContainer cc = (CoreContainer)req.getContext().get(CoreContainer.class.getName());
            loader = cc.getResourceLoader();
        }
        CoreAdminHandler.Invocable invokable = loader.newInstance(c, CoreAdminHandler.Invocable.class);
        Map<String, Object> result = invokable.invoke(req);
        log.info("Invocable_invoked {}", result);
        return result;
    }

    @Override
    public void execute(CoreAdminHandler.CallInfo it) throws Exception {
        String[] klas = it.req.getParams().getParams("class");
        if (klas == null || klas.length == 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "class is a required param");
        }
        for (String c : klas) {
            Map<String, Object> result = InvokeOp.invokeAClass(it.req, c);
            it.rsp.add(c, result);
        }
    }
}

