/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.CollectPreconditions;
import java.util.Collection;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Collections2 {
    static boolean safeContains(Collection collection, @NullableDecl Object object) {
        Preconditions.checkNotNull(collection);
        try {
            return collection.contains(object);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
    }

    static boolean safeRemove(Collection collection, @NullableDecl Object object) {
        Preconditions.checkNotNull(collection);
        try {
            return collection.remove(object);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
    }

    static boolean containsAllImpl(Collection collection, Collection collection2) {
        for (Object e : collection2) {
            if (collection.contains(e)) continue;
            return false;
        }
        return true;
    }

    static String toStringImpl(Collection collection) {
        StringBuilder stringBuilder = Collections2.newStringBuilderForCollection(collection.size()).append('[');
        boolean bl = true;
        for (Object e : collection) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            if (e == collection) {
                stringBuilder.append("(this Collection)");
                continue;
            }
            stringBuilder.append(e);
        }
        return stringBuilder.append(']').toString();
    }

    static StringBuilder newStringBuilderForCollection(int n) {
        CollectPreconditions.checkNonnegative(n, "size");
        return new StringBuilder((int)Math.min((long)n * 8L, 0x40000000L));
    }
}

