/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.interleaving;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TopDocs;
import org.apache.solr.ltr.LTRRescorer;
import org.apache.solr.ltr.LTRScoringQuery;
import org.apache.solr.ltr.interleaving.Interleaving;
import org.apache.solr.ltr.interleaving.InterleavingResult;
import org.apache.solr.ltr.interleaving.LTRInterleavingScoringQuery;
import org.apache.solr.ltr.interleaving.OriginalRankingLTRScoringQuery;

public class LTRInterleavingRescorer
extends LTRRescorer {
    private final LTRInterleavingScoringQuery[] rerankingQueries;
    private Integer originalRankingIndex = null;
    private final Interleaving interleavingAlgorithm;

    public LTRInterleavingRescorer(Interleaving interleavingAlgorithm, LTRInterleavingScoringQuery[] rerankingQueries) {
        this.rerankingQueries = rerankingQueries;
        this.interleavingAlgorithm = interleavingAlgorithm;
        for (int i = 0; i < this.rerankingQueries.length; ++i) {
            if (!(this.rerankingQueries[i] instanceof OriginalRankingLTRScoringQuery)) continue;
            this.originalRankingIndex = i;
        }
    }

    @Override
    public TopDocs rescore(IndexSearcher searcher, TopDocs firstPassTopDocs, int topN) throws IOException {
        if (topN == 0 || firstPassTopDocs.scoreDocs.length == 0) {
            return firstPassTopDocs;
        }
        ScoreDoc[] firstPassResults = null;
        if (this.originalRankingIndex != null) {
            firstPassResults = new ScoreDoc[firstPassTopDocs.scoreDocs.length];
            System.arraycopy(firstPassTopDocs.scoreDocs, 0, firstPassResults, 0, firstPassTopDocs.scoreDocs.length);
        }
        topN = Math.toIntExact(Math.min((long)topN, firstPassTopDocs.totalHits.value));
        ScoreDoc[][] reRankedPerModel = this.rerank(searcher, topN, LTRInterleavingRescorer.getFirstPassDocsRanked(firstPassTopDocs));
        if (this.originalRankingIndex != null) {
            reRankedPerModel[this.originalRankingIndex.intValue()] = firstPassResults;
        }
        InterleavingResult interleaved = this.interleavingAlgorithm.interleave(reRankedPerModel[0], reRankedPerModel[1]);
        ScoreDoc[] interleavedResults = interleaved.getInterleavedResults();
        ArrayList<Set<Integer>> interleavingPicks = interleaved.getInterleavingPicks();
        this.rerankingQueries[0].setPickedInterleavingDocIds(interleavingPicks.get(0));
        this.rerankingQueries[1].setPickedInterleavingDocIds(interleavingPicks.get(1));
        return new TopDocs(firstPassTopDocs.totalHits, interleavedResults);
    }

    private ScoreDoc[][] rerank(IndexSearcher searcher, int topN, ScoreDoc[] firstPassResults) throws IOException {
        int i;
        ScoreDoc[][] reRankedPerModel = new ScoreDoc[this.rerankingQueries.length][topN];
        List leaves = searcher.getIndexReader().leaves();
        LTRScoringQuery.ModelWeight[] modelWeights = new LTRScoringQuery.ModelWeight[this.rerankingQueries.length];
        for (i = 0; i < this.rerankingQueries.length; ++i) {
            if (this.originalRankingIndex != null && this.originalRankingIndex == i) continue;
            modelWeights[i] = (LTRScoringQuery.ModelWeight)searcher.createWeight(searcher.rewrite((Query)this.rerankingQueries[i]), ScoreMode.COMPLETE, 1.0f);
        }
        this.scoreFeatures(searcher, topN, modelWeights, firstPassResults, (List<LeafReaderContext>)leaves, reRankedPerModel);
        for (i = 0; i < this.rerankingQueries.length; ++i) {
            if (this.originalRankingIndex != null && this.originalRankingIndex == i) continue;
            Arrays.sort(reRankedPerModel[i], scoreComparator);
        }
        return reRankedPerModel;
    }

    public void scoreFeatures(IndexSearcher indexSearcher, int topN, LTRScoringQuery.ModelWeight[] modelWeights, ScoreDoc[] hits, List<LeafReaderContext> leaves, ScoreDoc[][] rerankedPerModel) throws IOException {
        int readerUpto = -1;
        int endDoc = 0;
        int docBase = 0;
        LTRScoringQuery.ModelWeight.ModelScorer[] scorers = new LTRScoringQuery.ModelWeight.ModelScorer[this.rerankingQueries.length];
        for (int hitUpto = 0; hitUpto < hits.length; ++hitUpto) {
            int i;
            ScoreDoc hit = hits[hitUpto];
            int docID = hit.doc;
            LeafReaderContext readerContext = null;
            while (docID >= endDoc) {
                readerContext = leaves.get(++readerUpto);
                endDoc = readerContext.docBase + readerContext.reader().maxDoc();
            }
            if (readerContext != null) {
                docBase = readerContext.docBase;
                for (i = 0; i < modelWeights.length; ++i) {
                    if (modelWeights[i] == null) continue;
                    scorers[i] = modelWeights[i].scorer(readerContext);
                }
            }
            for (i = 0; i < this.rerankingQueries.length; ++i) {
                ScoreDoc hit_i;
                if (modelWeights[i] == null || !LTRInterleavingRescorer.scoreSingleHit(topN, docBase, hitUpto, hit_i = new ScoreDoc(hit.doc, hit.score, hit.shardIndex), docID, scorers[i], rerankedPerModel[i])) continue;
                LTRInterleavingRescorer.logSingleHit(indexSearcher, modelWeights[i], hit_i.doc, this.rerankingQueries[i]);
            }
        }
    }

    @Override
    public Explanation explain(IndexSearcher searcher, Explanation firstPassExplanation, int docID) throws IOException {
        LTRInterleavingScoringQuery pickedRerankModel = this.rerankingQueries[0];
        if (this.rerankingQueries[1].getPickedInterleavingDocIds().contains(docID)) {
            pickedRerankModel = this.rerankingQueries[1];
        }
        return LTRInterleavingRescorer.getExplanation(searcher, docID, pickedRerankModel);
    }
}

