/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;

public class HdfsNamedFileStatus
extends FileStatus
implements HdfsFileStatus {
    private byte[] uPath;
    private byte[] uSymlink;
    private final long fileId;
    private final FileEncryptionInfo feInfo;
    private final ErasureCodingPolicy ecPolicy;
    private final int childrenNum;
    private final byte storagePolicy;

    HdfsNamedFileStatus(long length, boolean isdir, int replication, long blocksize, long mtime, long atime, FsPermission permission, Set<HdfsFileStatus.Flags> flags, String owner, String group, byte[] symlink, byte[] path, long fileId, int childrenNum, FileEncryptionInfo feInfo, byte storagePolicy, ErasureCodingPolicy ecPolicy) {
        super(length, isdir, replication, blocksize, mtime, atime, HdfsFileStatus.convert(isdir, symlink != null, permission, flags), owner, group, null, null, HdfsFileStatus.convert(flags));
        this.uSymlink = symlink;
        this.uPath = path;
        this.fileId = fileId;
        this.childrenNum = childrenNum;
        this.feInfo = feInfo;
        this.storagePolicy = storagePolicy;
        this.ecPolicy = ecPolicy;
    }

    @Override
    public void setOwner(String owner) {
        super.setOwner(owner);
    }

    @Override
    public void setGroup(String group) {
        super.setOwner(group);
    }

    @Override
    public boolean isSymlink() {
        return this.uSymlink != null;
    }

    @Override
    public Path getSymlink() throws IOException {
        if (this.isSymlink()) {
            return new Path(DFSUtilClient.bytes2String(this.getSymlinkInBytes()));
        }
        throw new IOException("Path " + this.getPath() + " is not a symbolic link");
    }

    @Override
    public void setPermission(FsPermission permission) {
        super.setPermission(permission);
    }

    @Override
    public byte[] getLocalNameInBytes() {
        return this.uPath;
    }

    @Override
    public void setSymlink(Path sym) {
        this.uSymlink = DFSUtilClient.string2Bytes(sym.toString());
    }

    @Override
    public byte[] getSymlinkInBytes() {
        return this.uSymlink;
    }

    @Override
    public long getFileId() {
        return this.fileId;
    }

    @Override
    public FileEncryptionInfo getFileEncryptionInfo() {
        return this.feInfo;
    }

    @Override
    public ErasureCodingPolicy getErasureCodingPolicy() {
        return this.ecPolicy;
    }

    @Override
    public int getChildrenNum() {
        return this.childrenNum;
    }

    @Override
    public byte getStoragePolicy() {
        return this.storagePolicy;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

