/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.Consumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

class StringStreamFilterFunction
extends StringValueStream.AbstractStringValueStream {
    private final StringValueStream baseExpr;
    private final BooleanValue filterExpr;
    public static final String name = "filter";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public StringStreamFilterFunction(StringValueStream baseExpr, BooleanValue filterExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.filterExpr = filterExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, filterExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, filterExpr);
    }

    @Override
    public void streamStrings(Consumer<String> cons) {
        if (this.filterExpr.getBoolean() && this.filterExpr.exists()) {
            this.baseExpr.streamStrings(cons);
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

