/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.QueryBitSetProducer;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.search.join.ToParentBlockJoinQuery;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.BitsFilteredDocIdSet;
import org.apache.solr.search.Filter;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrConstantScoreQuery;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.join.FiltersQParser;
import org.apache.solr.search.join.ScoreModeParser;

public class BlockJoinParentQParser
extends FiltersQParser {
    public static final String CACHE_NAME = "perSegFilter";

    protected String getParentFilterLocalParamName() {
        return "which";
    }

    @Override
    protected String getFiltersParamName() {
        return "filters";
    }

    BlockJoinParentQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    protected Query parseParentFilter() throws SyntaxError {
        String filter = this.localParams.get(this.getParentFilterLocalParamName());
        QParser parentParser = this.subQuery(filter, null);
        Query parentQ = parentParser.getQuery();
        return parentQ;
    }

    @Override
    protected Query wrapSubordinateClause(Query subordinate) throws SyntaxError {
        String scoreMode = this.localParams.get("score", ScoreMode.None.name());
        Query parentQ = this.parseParentFilter();
        return this.createQuery(parentQ, subordinate, scoreMode);
    }

    @Override
    protected Query noClausesQuery() throws SyntaxError {
        SolrConstantScoreQuery wrapped = new SolrConstantScoreQuery(this.getFilter(this.parseParentFilter()));
        wrapped.setCache(false);
        return wrapped;
    }

    protected Query createQuery(Query parentList, Query query, String scoreMode) throws SyntaxError {
        return new AllParentsAware(query, this.getFilter((Query)parentList).filter, ScoreModeParser.parse(scoreMode), parentList);
    }

    BitDocIdSetFilterWrapper getFilter(Query parentList) {
        return BlockJoinParentQParser.getCachedFilter(this.req, parentList);
    }

    static BitDocIdSetFilterWrapper getCachedFilter(SolrQueryRequest request, Query parentList) {
        BitDocIdSetFilterWrapper result;
        SolrCache parentCache = request.getSearcher().getCache(CACHE_NAME);
        Filter filter = null;
        if (parentCache != null) {
            filter = (Filter)((Object)parentCache.get(parentList));
        }
        if (filter instanceof BitDocIdSetFilterWrapper) {
            result = (BitDocIdSetFilterWrapper)filter;
        } else {
            result = new BitDocIdSetFilterWrapper(BlockJoinParentQParser.createParentFilter(parentList));
            if (parentCache != null) {
                parentCache.put(parentList, result);
            }
        }
        return result;
    }

    private static BitSetProducer createParentFilter(Query parentQ) {
        return new QueryBitSetProducer(parentQ);
    }

    static class BitDocIdSetFilterWrapper
    extends Filter {
        final BitSetProducer filter;

        BitDocIdSetFilterWrapper(BitSetProducer filter) {
            this.filter = filter;
        }

        @Override
        public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
            BitSet set = this.filter.getBitSet(context);
            if (set == null) {
                return null;
            }
            return BitsFilteredDocIdSet.wrap((DocIdSet)new BitDocIdSet(set), acceptDocs);
        }

        public String toString(String field) {
            return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.filter + ")";
        }

        public boolean equals(Object other) {
            return this.sameClassAs(other) && Objects.equals(this.filter, ((BitDocIdSetFilterWrapper)((Object)((Object)((Object)this)).getClass().cast((Object)other))).filter);
        }

        public int hashCode() {
            return this.classHash() + this.filter.hashCode();
        }
    }

    static final class AllParentsAware
    extends ToParentBlockJoinQuery {
        private final Query parentQuery;

        private AllParentsAware(Query childQuery, BitSetProducer parentsFilter, ScoreMode scoreMode, Query parentList) {
            super(childQuery, parentsFilter, scoreMode);
            this.parentQuery = parentList;
        }

        public Query getParentQuery() {
            return this.parentQuery;
        }
    }
}

