/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.solr.security.AuthorizationContext;

public interface PermissionNameProvider {
    public static final Set<String> NULL = Collections.singleton(null);
    public static final Set<String> ANY = Collections.singleton("*");
    public static final Map<String, Name> values = Collections.unmodifiableMap(Arrays.asList(Name.values()).stream().collect(Collectors.toMap(Name::getPermissionName, Function.identity())));

    public Name getPermissionName(AuthorizationContext var1);

    public static enum Name {
        COLL_EDIT_PERM("collection-admin-edit", null),
        COLL_READ_PERM("collection-admin-read", null),
        CORE_READ_PERM("core-admin-read", null),
        CORE_EDIT_PERM("core-admin-edit", null),
        READ_PERM("read", "*"),
        UPDATE_PERM("update", "*"),
        CONFIG_EDIT_PERM("config-edit", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("*", null)))),
        CONFIG_READ_PERM("config-read", "*"),
        SCHEMA_READ_PERM("schema-read", "*"),
        SCHEMA_EDIT_PERM("schema-edit", "*"),
        SECURITY_EDIT_PERM("security-edit", null),
        SECURITY_READ_PERM("security-read", null),
        METRICS_READ_PERM("metrics-read", null),
        AUTOSCALING_READ_PERM("autoscaling-read", null),
        AUTOSCALING_WRITE_PERM("autoscaling-write", null),
        AUTOSCALING_HISTORY_READ_PERM("autoscaling-history-read", null),
        METRICS_HISTORY_READ_PERM("metrics-history-read", null),
        ALL("all", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("*", null))));

        final String name;
        final Set<String> collName;

        private Name(String s, Object collName) {
            this.name = s;
            this.collName = collName instanceof Set ? (Set<String>)collName : Collections.singleton((String)collName);
        }

        public static Name get(String s) {
            return values.get(s);
        }

        public String getPermissionName() {
            return this.name;
        }
    }
}

