/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import com.codahale.metrics.MetricRegistry;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.solr.common.SolrException;
import org.apache.solr.metrics.MetricsMap;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.search.CacheRegenerator;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrCacheBase;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.ConcurrentLRUCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastLRUCache<K, V>
extends SolrCacheBase
implements SolrCache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private List<ConcurrentLRUCache.Stats> statsList;
    private long warmupTime = 0L;
    private String description = "Concurrent LRU Cache";
    private ConcurrentLRUCache<K, V> cache;
    private int showItems = 0;
    private long maxRamBytes;
    private MetricsMap cacheMap;
    private Set<String> metricNames = ConcurrentHashMap.newKeySet();
    private MetricRegistry registry;
    private SolrMetricManager metricManager;
    private String registryName;

    @Override
    public Object init(Map args, Object persistence, CacheRegenerator regenerator) {
        super.init(args, regenerator);
        String str = (String)args.get("size");
        int limit = str == null ? 1024 : Integer.parseInt(str);
        str = (String)args.get("minSize");
        int minLimit = str == null ? (int)((double)limit * 0.9) : Integer.parseInt(str);
        if (minLimit <= 0) {
            minLimit = 1;
        }
        if (limit <= minLimit) {
            limit = minLimit + 1;
        }
        int acceptableLimit = (str = (String)args.get("acceptableSize")) == null ? (int)((double)limit * 0.95) : Integer.parseInt(str);
        acceptableLimit = Math.max(minLimit, acceptableLimit);
        str = (String)args.get("initialSize");
        int initialSize = str == null ? limit : Integer.parseInt(str);
        str = (String)args.get("cleanupThread");
        boolean newThread = str == null ? false : Boolean.parseBoolean(str);
        str = (String)args.get("showItems");
        this.showItems = str == null ? 0 : Integer.parseInt(str);
        str = (String)args.get("maxRamMB");
        long l = this.maxRamBytes = str == null ? Long.MAX_VALUE : (long)(Double.parseDouble(str) * 1024.0 * 1024.0);
        if (this.maxRamBytes != Long.MAX_VALUE) {
            int ramLowerWatermark = (int)((double)this.maxRamBytes * 0.8);
            this.description = this.generateDescription(this.maxRamBytes, ramLowerWatermark, newThread);
            this.cache = new ConcurrentLRUCache(ramLowerWatermark, this.maxRamBytes, newThread, null);
        } else {
            this.description = this.generateDescription(limit, initialSize, minLimit, acceptableLimit, newThread);
            this.cache = new ConcurrentLRUCache(limit, minLimit, acceptableLimit, initialSize, newThread, false, null);
        }
        this.cache.setAlive(false);
        this.statsList = (List)persistence;
        if (this.statsList == null) {
            this.statsList = new CopyOnWriteArrayList<ConcurrentLRUCache.Stats>();
            this.statsList.add(new ConcurrentLRUCache.Stats());
        }
        this.statsList.add(this.cache.getStats());
        return this.statsList;
    }

    protected String generateDescription(int limit, int initialSize, int minLimit, int acceptableLimit, boolean newThread) {
        String description = "Concurrent LRU Cache(maxSize=" + limit + ", initialSize=" + initialSize + ", minSize=" + minLimit + ", acceptableSize=" + acceptableLimit + ", cleanupThread=" + newThread;
        if (this.isAutowarmingOn()) {
            description = description + ", " + this.getAutowarmDescription();
        }
        description = description + ')';
        return description;
    }

    protected String generateDescription(long maxRamBytes, long ramLowerWatermark, boolean newThread) {
        String description = "Concurrent LRU Cache(ramMinSize=" + ramLowerWatermark + ", ramMaxSize=" + maxRamBytes + ", cleanupThread=" + newThread;
        if (this.isAutowarmingOn()) {
            description = description + ", " + this.getAutowarmDescription();
        }
        description = description + ')';
        return description;
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public V put(K key, V value) {
        return this.cache.put(key, value);
    }

    @Override
    public V get(K key) {
        return this.cache.get(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void setState(SolrCache.State state) {
        super.setState(state);
        this.cache.setAlive(state == SolrCache.State.LIVE);
    }

    @Override
    public void warm(SolrIndexSearcher searcher, SolrCache old) {
        if (this.regenerator == null) {
            return;
        }
        long warmingStartTime = System.nanoTime();
        FastLRUCache other = (FastLRUCache)old;
        if (this.isAutowarmingOn()) {
            int sz = this.autowarm.getWarmCount(other.size());
            Map<K, V> items = other.cache.getLatestAccessedItems(sz);
            Map.Entry[] itemsArr = new Map.Entry[items.size()];
            int counter = 0;
            for (Map.Entry<K, V> mapEntry : items.entrySet()) {
                itemsArr[counter++] = mapEntry;
            }
            for (int i = itemsArr.length - 1; i >= 0; --i) {
                try {
                    boolean continueRegen = this.regenerator.regenerateItem(searcher, this, old, itemsArr[i].getKey(), itemsArr[i].getValue());
                    if (continueRegen) continue;
                    break;
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (String)("Error during auto-warming of key:" + itemsArr[i].getKey()), (Throwable)e);
                }
            }
        }
        this.warmupTime = TimeUnit.MILLISECONDS.convert(System.nanoTime() - warmingStartTime, TimeUnit.NANOSECONDS);
    }

    @Override
    public void close() {
        this.statsList.get(0).add(this.cache.getStats());
        this.statsList.remove(this.cache.getStats());
        this.cache.destroy();
    }

    @Override
    public String getName() {
        return FastLRUCache.class.getName();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Set<String> getMetricNames() {
        return this.metricNames;
    }

    @Override
    public void initializeMetrics(SolrMetricManager manager, String registryName, String tag, String scope) {
        this.metricManager = manager;
        this.registryName = registryName;
        this.registry = manager.registry(registryName);
        this.cacheMap = new MetricsMap((detailed, map) -> {
            if (this.cache != null) {
                ConcurrentLRUCache.Stats stats = this.cache.getStats();
                long lookups = stats.getCumulativeLookups();
                long hits = stats.getCumulativeHits();
                long inserts = stats.getCumulativePuts();
                long evictions = stats.getCumulativeEvictions();
                long size = stats.getCurrentSize();
                long clookups = 0L;
                long chits = 0L;
                long cinserts = 0L;
                long cevictions = 0L;
                for (ConcurrentLRUCache.Stats statistiscs : this.statsList) {
                    clookups += statistiscs.getCumulativeLookups();
                    chits += statistiscs.getCumulativeHits();
                    cinserts += statistiscs.getCumulativePuts();
                    cevictions += statistiscs.getCumulativeEvictions();
                }
                map.put("lookups", lookups);
                map.put("hits", hits);
                map.put("hitratio", Float.valueOf(FastLRUCache.calcHitRatio(lookups, hits)));
                map.put("inserts", inserts);
                map.put("evictions", evictions);
                map.put("size", size);
                map.put("warmupTime", this.warmupTime);
                map.put("cumulative_lookups", clookups);
                map.put("cumulative_hits", chits);
                map.put("cumulative_hitratio", Float.valueOf(FastLRUCache.calcHitRatio(clookups, chits)));
                map.put("cumulative_inserts", cinserts);
                map.put("cumulative_evictions", cevictions);
                if (detailed.booleanValue() && this.showItems != 0) {
                    Map<K, V> items = this.cache.getLatestAccessedItems(this.showItems == -1 ? Integer.MAX_VALUE : this.showItems);
                    for (Map.Entry<K, V> e : items.entrySet()) {
                        K k = e.getKey();
                        V v = e.getValue();
                        String ks = "item_" + k;
                        String vs = v.toString();
                        map.put(ks, vs);
                    }
                }
            }
        });
        manager.registerGauge(this, registryName, this.cacheMap, tag, true, scope, this.getCategory().toString());
    }

    MetricsMap getMetricsMap() {
        return this.cacheMap;
    }

    @Override
    public MetricRegistry getMetricRegistry() {
        return this.registry;
    }

    public String toString() {
        return this.name() + (this.cacheMap != null ? this.cacheMap.getValue().toString() : "");
    }
}

