/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SlowCodecReaderWrapper;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.SuppressForbidden;

public class FixBrokenOffsets {
    public SegmentInfos infos;
    FSDirectory fsDir;
    Path dir;

    @SuppressForbidden(reason="System.out required: command line tool")
    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.err.println("Usage: FixBrokenOffsetse <srcDir> <destDir>");
            return;
        }
        Path srcPath = Paths.get(args[0], new String[0]);
        if (!Files.exists(srcPath, new LinkOption[0])) {
            throw new RuntimeException("srcPath " + srcPath.toAbsolutePath() + " doesn't exist");
        }
        Path destPath = Paths.get(args[1], new String[0]);
        if (Files.exists(destPath, new LinkOption[0])) {
            throw new RuntimeException("destPath " + destPath.toAbsolutePath() + " already exists; please remove it and re-run");
        }
        FSDirectory srcDir = FSDirectory.open((Path)srcPath);
        DirectoryReader reader = DirectoryReader.open((Directory)srcDir);
        List leaves = reader.leaves();
        CodecReader[] filtered = new CodecReader[leaves.size()];
        for (int i = 0; i < leaves.size(); ++i) {
            filtered[i] = SlowCodecReaderWrapper.wrap((LeafReader)new FilterLeafReader(((LeafReaderContext)leaves.get(i)).reader()){

                public Fields getTermVectors(int docID) throws IOException {
                    Fields termVectors = this.in.getTermVectors(docID);
                    if (termVectors == null) {
                        return null;
                    }
                    return new FilterLeafReader.FilterFields(termVectors){

                        public Terms terms(String field) throws IOException {
                            return new FilterLeafReader.FilterTerms(super.terms(field)){

                                public TermsEnum iterator() throws IOException {
                                    return new FilterLeafReader.FilterTermsEnum(super.iterator()){

                                        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
                                            return new FilterLeafReader.FilterPostingsEnum(super.postings(reuse, flags)){
                                                int nextLastStartOffset;
                                                int lastStartOffset;
                                                {
                                                    super(x0);
                                                    this.nextLastStartOffset = 0;
                                                    this.lastStartOffset = 0;
                                                }

                                                public int nextPosition() throws IOException {
                                                    int pos = super.nextPosition();
                                                    this.lastStartOffset = this.nextLastStartOffset;
                                                    this.nextLastStartOffset = this.startOffset();
                                                    return pos;
                                                }

                                                public int startOffset() throws IOException {
                                                    int offset = super.startOffset();
                                                    if (offset < this.lastStartOffset) {
                                                        offset = this.lastStartOffset;
                                                    }
                                                    return offset;
                                                }

                                                public int endOffset() throws IOException {
                                                    int offset = super.endOffset();
                                                    if (offset < this.lastStartOffset) {
                                                        offset = this.lastStartOffset;
                                                    }
                                                    return offset;
                                                }
                                            };
                                        }
                                    };
                                }
                            };
                        }
                    };
                }

                public IndexReader.CacheHelper getCoreCacheHelper() {
                    return null;
                }

                public IndexReader.CacheHelper getReaderCacheHelper() {
                    return null;
                }
            });
        }
        FSDirectory destDir = FSDirectory.open((Path)destPath);
        int createdMajor = SegmentInfos.readLatestCommit((Directory)srcDir).getIndexCreatedVersionMajor();
        new SegmentInfos(createdMajor).commit((Directory)destDir);
        IndexWriter writer = new IndexWriter((Directory)destDir, new IndexWriterConfig());
        writer.addIndexes(filtered);
        IOUtils.close((Closeable[])new Closeable[]{writer, reader, srcDir, destDir});
    }
}

