/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction;

import java.util.function.UnaryOperator;
import org.apache.solr.analytics.function.ReductionFunction;
import org.apache.solr.analytics.function.reduction.data.MinCollector;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;

class DoubleMinFunction
extends DoubleValue.AbstractDoubleValue
implements ReductionFunction {
    private MinCollector.DoubleMinCollector collector;
    public static final String name = "min";
    private final String exprStr;

    public DoubleMinFunction(DoubleValueStream param) {
        this.collector = new MinCollector.DoubleMinCollector(param);
        this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
    }

    @Override
    public double getDouble() {
        return this.collector.exists() ? this.collector.min() : 0.0;
    }

    @Override
    public boolean exists() {
        return this.collector.exists();
    }

    @Override
    public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
        this.collector = (MinCollector.DoubleMinCollector)sync.apply(this.collector);
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return AnalyticsValueStream.ExpressionType.REDUCTION;
    }
}

