#region Apache License
//
// Licensed to the Apache Software Foundation (ASF) under one or more 
// contributor license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright ownership. 
// The ASF licenses this file to you under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with 
// the License. You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
#endregion

using System;
using System.Collections;

namespace log4net.Util
{
  /// <summary>
  /// Base class for Context Properties implementations
  /// </summary>
  /// <remarks>
  /// <para>
  /// This class defines a basic property get set accessor
  /// </para>
  /// </remarks>
  /// <author>Nicko Cadell</author>
  public abstract class ContextPropertiesBase
  {
    /// <summary>
    /// Gets or sets the value of a property
    /// </summary>
    /// <value>
    /// The value for the property with the specified key
    /// </value>
    /// <remarks>
    /// <para>
    /// Gets or sets the value of a property
    /// </para>
    /// </remarks>
    public abstract object this[string key] { get; set; }
  }
}

