/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.appender.rolling.AbstractRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.PatternProcessor;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverDescription;
import org.apache.logging.log4j.core.appender.rolling.RolloverDescriptionImpl;
import org.apache.logging.log4j.core.appender.rolling.action.Action;
import org.apache.logging.log4j.core.appender.rolling.action.CompositeAction;
import org.apache.logging.log4j.core.appender.rolling.action.CompressActionFactory;
import org.apache.logging.log4j.core.appender.rolling.action.CompressActionFactoryProvider;
import org.apache.logging.log4j.core.appender.rolling.action.FileRenameAction;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.apache.logging.log4j.core.appender.rolling.action.PosixViewAttributeAction;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.NullConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.plugins.PluginElement;
import org.apache.logging.log4j.plugins.PluginFactory;

@Configurable(printObject=true)
@Plugin
public class DefaultRolloverStrategy
extends AbstractRolloverStrategy {
    private static final int MIN_WINDOW_SIZE = 1;
    private static final int DEFAULT_WINDOW_SIZE = 7;
    private final int maxIndex;
    private final int minIndex;
    private final boolean useMax;
    private final List<Action> customActions;
    private final boolean stopCustomActionsOnError;
    private final PatternProcessor tempCompressedFilePattern;

    @PluginFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    private DefaultRolloverStrategy(int minIndex, int maxIndex, boolean useMax, StrSubstitutor strSubstitutor, Action[] customActions, boolean stopCustomActionsOnError, String tempCompressedFilePatternString, Configuration configuration) {
        super(CompressActionFactoryProvider.newInstance(configuration), strSubstitutor);
        this.minIndex = minIndex;
        this.maxIndex = maxIndex;
        this.useMax = useMax;
        this.stopCustomActionsOnError = stopCustomActionsOnError;
        this.customActions = customActions == null ? Collections.emptyList() : Arrays.asList(customActions);
        this.tempCompressedFilePattern = tempCompressedFilePatternString != null ? new PatternProcessor(configuration, tempCompressedFilePatternString) : null;
    }

    public List<Action> getCustomActions() {
        return this.customActions;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public boolean isStopCustomActionsOnError() {
        return this.stopCustomActionsOnError;
    }

    public boolean isUseMax() {
        return this.useMax;
    }

    public PatternProcessor getTempCompressedFilePattern() {
        return this.tempCompressedFilePattern;
    }

    private int purge(int lowIndex, int highIndex, RollingFileManager manager) {
        return this.useMax ? this.purgeAscending(lowIndex, highIndex, manager) : this.purgeDescending(lowIndex, highIndex, manager);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The name of the accessed files is based on a configuration value.")
    private int purgeAscending(int lowIndex, int highIndex, RollingFileManager manager) {
        boolean renameFiles;
        SortedMap<Integer, Path> eligibleFiles = this.getEligibleFiles(manager);
        int maxFiles = highIndex - lowIndex + 1;
        LOGGER.debug("Eligible files: {}", eligibleFiles);
        boolean bl = renameFiles = !eligibleFiles.isEmpty() && eligibleFiles.lastKey() >= this.maxIndex;
        while (eligibleFiles.size() >= maxFiles) {
            try {
                LOGGER.debug("Eligible files: {}", eligibleFiles);
                Integer key = eligibleFiles.firstKey();
                LOGGER.debug("Deleting {}", (Object)((Path)eligibleFiles.get(key)).toFile().getAbsolutePath());
                Files.delete((Path)eligibleFiles.get(key));
                eligibleFiles.remove(key);
                renameFiles = true;
            }
            catch (IOException ioe) {
                LOGGER.error("Unable to delete {}, {}", (Object)eligibleFiles.firstKey(), (Object)ioe.getMessage(), (Object)ioe);
                break;
            }
        }
        StringBuilder buf = new StringBuilder();
        if (renameFiles) {
            for (Map.Entry<Integer, Path> entry : eligibleFiles.entrySet()) {
                buf.setLength(0);
                manager.getPatternProcessor().formatFileName(this.strSubstitutor, buf, (Object)(entry.getKey() - 1));
                String currentName = entry.getValue().toFile().getName();
                String renameTo = buf.toString();
                int suffixLength = this.suffixLength(renameTo);
                if (suffixLength > 0 && this.suffixLength(currentName) == 0) {
                    renameTo = renameTo.substring(0, renameTo.length() - suffixLength);
                }
                FileRenameAction action = new FileRenameAction(entry.getValue().toFile(), new File(renameTo), true);
                try {
                    LOGGER.debug("DefaultRolloverStrategy.purgeAscending executing {}", (Object)action);
                    if (action.execute()) continue;
                    return -1;
                }
                catch (Exception ex) {
                    LOGGER.warn("Exception during purge in RollingFileAppender", (Throwable)ex);
                    return -1;
                }
            }
        }
        return eligibleFiles.isEmpty() ? lowIndex : (eligibleFiles.lastKey() < highIndex ? eligibleFiles.lastKey() + 1 : highIndex);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The name of the accessed files is based on a configuration value.")
    private int purgeDescending(int lowIndex, int highIndex, RollingFileManager manager) {
        SortedMap<Integer, Path> eligibleFiles = this.getEligibleFiles(manager, false);
        int maxFiles = highIndex - lowIndex + 1;
        LOGGER.debug("Eligible files: {}", eligibleFiles);
        while (eligibleFiles.size() >= maxFiles) {
            try {
                Integer key = eligibleFiles.firstKey();
                LOGGER.debug("Deleting {}", (Object)((Path)eligibleFiles.get(key)).toFile().getAbsolutePath());
                Files.delete((Path)eligibleFiles.get(key));
                eligibleFiles.remove(key);
            }
            catch (IOException ioe) {
                LOGGER.error("Unable to delete {}, {}", (Object)eligibleFiles.firstKey(), (Object)ioe.getMessage(), (Object)ioe);
                break;
            }
        }
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<Integer, Path> entry : eligibleFiles.entrySet()) {
            buf.setLength(0);
            manager.getPatternProcessor().formatFileName(this.strSubstitutor, buf, (Object)(entry.getKey() + 1));
            String currentName = entry.getValue().toFile().getName();
            String renameTo = buf.toString();
            int suffixLength = this.suffixLength(renameTo);
            if (suffixLength > 0 && this.suffixLength(currentName) == 0) {
                renameTo = renameTo.substring(0, renameTo.length() - suffixLength);
            }
            FileRenameAction action = new FileRenameAction(entry.getValue().toFile(), new File(renameTo), true);
            try {
                LOGGER.debug("DefaultRolloverStrategy.purgeDescending executing {}", (Object)action);
                if (action.execute()) continue;
                return -1;
            }
            catch (Exception ex) {
                LOGGER.warn("Exception during purge in RollingFileAppender", (Throwable)ex);
                return -1;
            }
        }
        return lowIndex;
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The name of the accessed files is based on a configuration value.")
    public RolloverDescription rollover(RollingFileManager manager) throws SecurityException {
        String renameTo;
        int fileIndex;
        StringBuilder buf = new StringBuilder(255);
        if (this.minIndex == Integer.MIN_VALUE) {
            SortedMap<Integer, Path> eligibleFiles = this.getEligibleFiles(manager);
            fileIndex = eligibleFiles.isEmpty() ? 1 : eligibleFiles.lastKey() + 1;
            manager.getPatternProcessor().formatFileName(this.strSubstitutor, buf, (Object)fileIndex);
        } else {
            if (this.maxIndex < 0) {
                return null;
            }
            long startNanos = System.nanoTime();
            fileIndex = this.purge(this.minIndex, this.maxIndex, manager);
            if (fileIndex < 0) {
                return null;
            }
            manager.getPatternProcessor().formatFileName(this.strSubstitutor, buf, (Object)fileIndex);
            if (LOGGER.isTraceEnabled()) {
                double durationMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
                LOGGER.trace("DefaultRolloverStrategy.purge() took {} milliseconds", (Object)durationMillis);
            }
        }
        String currentFileName = manager.getFileName();
        String compressedName = renameTo = buf.toString();
        Action compressAction = null;
        CompressActionFactory compressActionFactory = manager.getCompressActionFactory();
        if (compressActionFactory != null) {
            File renameToFile = new File(renameTo);
            renameTo = renameTo.substring(0, renameTo.length() - compressActionFactory.getExtension().length());
            if (this.tempCompressedFilePattern != null) {
                buf.delete(0, buf.length());
                this.tempCompressedFilePattern.formatFileName(this.strSubstitutor, buf, (Object)fileIndex);
                String tmpCompressedName = buf.toString();
                File tmpCompressedNameFile = new File(tmpCompressedName);
                File parentFile = tmpCompressedNameFile.getParentFile();
                if (parentFile != null) {
                    parentFile.mkdirs();
                }
                compressAction = new CompositeAction(Arrays.asList(compressActionFactory.createCompressAction(renameTo, tmpCompressedName, Map.of()), new FileRenameAction(tmpCompressedNameFile, renameToFile, true)), true);
            } else {
                compressAction = compressActionFactory.createCompressAction(renameTo, compressedName, Map.of());
            }
        }
        if (currentFileName.equals(renameTo)) {
            LOGGER.warn("Attempt to rename file {} to itself will be ignored", (Object)currentFileName);
            return new RolloverDescriptionImpl(currentFileName, false, null, null);
        }
        if (compressAction != null && manager.isAttributeViewEnabled()) {
            PosixViewAttributeAction posixAttributeViewAction = PosixViewAttributeAction.newBuilder().setBasePath(compressedName).setFollowLinks(false).setMaxDepth(1).setPathConditions(PathCondition.EMPTY_ARRAY).setSubst(this.getStrSubstitutor()).setFilePermissions(manager.getFilePermissions()).setFileOwner(manager.getFileOwner()).setFileGroup(manager.getFileGroup()).build();
            compressAction = new CompositeAction(Arrays.asList(compressAction, posixAttributeViewAction), false);
        }
        FileRenameAction renameAction = new FileRenameAction(new File(currentFileName), new File(renameTo), manager.isRenameEmptyFiles());
        Action asyncAction = this.merge(compressAction, this.customActions, this.stopCustomActionsOnError);
        return new RolloverDescriptionImpl(currentFileName, false, renameAction, asyncAction);
    }

    public String toString() {
        return "DefaultRolloverStrategy(min=" + this.minIndex + ", max=" + this.maxIndex + ", useMax=" + this.useMax + ")";
    }

    public static class Builder
    implements org.apache.logging.log4j.plugins.util.Builder<DefaultRolloverStrategy> {
        @PluginBuilderAttribute(value="max")
        private @PluginBuilderAttribute(value="max") String max;
        @PluginBuilderAttribute(value="min")
        private @PluginBuilderAttribute(value="min") String min;
        @PluginBuilderAttribute(value="fileIndex")
        private @PluginBuilderAttribute(value="fileIndex") String fileIndex;
        @PluginElement(value="Actions")
        private @PluginElement(value="Actions") Action[] customActions;
        @PluginBuilderAttribute(value="stopCustomActionsOnError")
        private @PluginBuilderAttribute(value="stopCustomActionsOnError") boolean stopCustomActionsOnError = true;
        @PluginBuilderAttribute(value="tempCompressedFilePattern")
        private @PluginBuilderAttribute(value="tempCompressedFilePattern") String tempCompressedFilePattern;
        @PluginConfiguration
        private Configuration config;

        public DefaultRolloverStrategy build() {
            boolean useMax;
            int maxIndex;
            int minIndex;
            if (this.fileIndex != null && this.fileIndex.equalsIgnoreCase("nomax")) {
                minIndex = Integer.MIN_VALUE;
                maxIndex = Integer.MAX_VALUE;
                useMax = false;
            } else {
                useMax = this.fileIndex == null || this.fileIndex.equalsIgnoreCase("max");
                minIndex = 1;
                if (this.min != null && (minIndex = Integer.parseInt(this.min.trim())) < 1) {
                    AbstractRolloverStrategy.LOGGER.error("Minimum window size too small. Limited to 1");
                    minIndex = 1;
                }
                maxIndex = 7;
                if (this.max != null && (maxIndex = Integer.parseInt(this.max.trim())) < minIndex) {
                    maxIndex = Math.max(minIndex, 7);
                    AbstractRolloverStrategy.LOGGER.error("Maximum window size must be greater than the minimum windows size. Set to " + maxIndex);
                }
            }
            Configuration configuration = this.config != null ? this.config : new NullConfiguration();
            StrSubstitutor nonNullStrSubstitutor = configuration.getStrSubstitutor();
            return new DefaultRolloverStrategy(minIndex, maxIndex, useMax, nonNullStrSubstitutor, this.customActions, this.stopCustomActionsOnError, this.tempCompressedFilePattern, configuration);
        }

        public String getMax() {
            return this.max;
        }

        public Builder setMax(String max) {
            this.max = max;
            return this;
        }

        public String getMin() {
            return this.min;
        }

        public Builder setMin(String min) {
            this.min = min;
            return this;
        }

        public String getFileIndex() {
            return this.fileIndex;
        }

        public Builder setFileIndex(String fileIndex) {
            this.fileIndex = fileIndex;
            return this;
        }

        public Action[] getCustomActions() {
            return this.customActions;
        }

        public Builder setCustomActions(Action ... customActions) {
            this.customActions = customActions;
            return this;
        }

        public boolean isStopCustomActionsOnError() {
            return this.stopCustomActionsOnError;
        }

        public Builder setStopCustomActionsOnError(boolean stopCustomActionsOnError) {
            this.stopCustomActionsOnError = stopCustomActionsOnError;
            return this;
        }

        public String getTempCompressedFilePattern() {
            return this.tempCompressedFilePattern;
        }

        public Builder setTempCompressedFilePattern(String tempCompressedFilePattern) {
            this.tempCompressedFilePattern = tempCompressedFilePattern;
            return this;
        }

        public Configuration getConfig() {
            return this.config;
        }

        public Builder setConfig(Configuration config) {
            this.config = config;
            return this;
        }
    }
}

