/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.filter.ThreadContextMapFilter;
import org.apache.logging.log4j.util.Unbox;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;

public abstract class AbstractConfigurationFactoryTest {
    private static final String LOGGER_NAME = "org.apache.logging.log4j.test1.Test";
    private static final String FILE_LOGGER_NAME = "org.apache.logging.log4j.test2.Test";
    private static final String APPENDER_NAME = "STDOUT";

    protected static void checkConfiguration(LoggerContext context) {
        Configuration configuration = context.getConfiguration();
        Map appenders = configuration.getAppenders();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)appenders), () -> Assertions.assertEquals((int)3, (int)appenders.size()), () -> Assertions.assertNotNull((Object)configuration.getLoggerContext()), () -> Assertions.assertEquals((Object)configuration.getRootLogger(), (Object)configuration.getLoggerConfig("")), () -> Assertions.assertThrows(NullPointerException.class, () -> configuration.getLoggerConfig(null))});
        Logger logger = context.getLogger(LOGGER_NAME);
        Assertions.assertEquals((Object)Level.DEBUG, (Object)logger.getLevel());
        Assertions.assertEquals((int)1, (int)logger.filterCount());
        Iterator filterIterator = logger.getFilters();
        Assertions.assertTrue((boolean)filterIterator.hasNext());
        Assertions.assertTrue((boolean)(filterIterator.next() instanceof ThreadContextMapFilter));
        Appender appender = (Appender)appenders.get(APPENDER_NAME);
        Assertions.assertTrue((boolean)(appender instanceof ConsoleAppender));
        Assertions.assertEquals((Object)APPENDER_NAME, (Object)appender.getName());
    }

    protected static void checkFileLogger(LoggerContext context, Path logFile) throws IOException {
        long currentThreadId = Thread.currentThread().getId();
        Logger logger = context.getLogger(FILE_LOGGER_NAME);
        logger.debug("Greetings from ConfigurationFactoryTest in thread#{}", (Object)Unbox.box((long)currentThreadId));
        List<String> lines = Files.readAllLines(logFile);
        Assertions.assertEquals((int)1, (int)lines.size());
        Assertions.assertTrue((boolean)lines.get(0).endsWith(Long.toString(currentThreadId)));
    }
}

