/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.time.Duration;
import java.time.temporal.ChronoUnit;

enum TimeUnit {
    NANOS("ns,nano,nanos,nanosecond,nanoseconds", ChronoUnit.NANOS),
    MICROS("us,micro,micros,microsecond,microseconds", ChronoUnit.MICROS),
    MILLIS("ms,milli,millis,millsecond,milliseconds", ChronoUnit.MILLIS),
    SECONDS("s,second,seconds", ChronoUnit.SECONDS),
    MINUTES("m,minute,minutes", ChronoUnit.MINUTES),
    HOURS("h,hour,hours", ChronoUnit.HOURS),
    DAYS("d,day,days", ChronoUnit.DAYS);

    private final String[] descriptions;
    private final ChronoUnit timeUnit;

    private TimeUnit(String descriptions, ChronoUnit timeUnit) {
        this.descriptions = descriptions.split(",");
        this.timeUnit = timeUnit;
    }

    ChronoUnit getTimeUnit() {
        return this.timeUnit;
    }

    static Duration getDuration(String time) {
        String value = time.trim();
        ChronoUnit temporalUnit = ChronoUnit.MILLIS;
        long timeVal = 0L;
        for (TimeUnit timeUnit : TimeUnit.values()) {
            for (String suffix : timeUnit.descriptions) {
                if (!value.endsWith(suffix)) continue;
                temporalUnit = timeUnit.timeUnit;
                timeVal = Long.parseLong(value.substring(0, value.length() - suffix.length()));
            }
        }
        return Duration.of(timeVal, temporalUnit);
    }
}

