/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.async.logger;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.async.logger.AsyncLoggerConfigDelegate;
import org.apache.logging.log4j.async.logger.AsyncLoggerConfigDisruptor;
import org.apache.logging.log4j.async.logger.AsyncWaitStrategyFactory;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.config.ConfigurationExtension;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAliases;
import org.apache.logging.log4j.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Lazy;
import org.apache.logging.log4j.util.LoaderUtil;

@Configurable(printObject=true)
@Plugin(value="Disruptor")
@PluginAliases(value={"AsyncWaitStrategyFactory"})
public final class DisruptorConfiguration
extends AbstractLifeCycle
implements ConfigurationExtension {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final AsyncWaitStrategyFactory waitStrategyFactory;
    private final Lazy<AsyncLoggerConfigDisruptor> loggerConfigDisruptor = Lazy.lazy(() -> new AsyncLoggerConfigDisruptor(this.getWaitStrategyFactory()));

    private DisruptorConfiguration(AsyncWaitStrategyFactory waitStrategyFactory) {
        this.waitStrategyFactory = waitStrategyFactory;
    }

    public AsyncWaitStrategyFactory getWaitStrategyFactory() {
        return this.waitStrategyFactory;
    }

    public AsyncLoggerConfigDelegate getAsyncLoggerConfigDelegate() {
        return (AsyncLoggerConfigDelegate)this.loggerConfigDisruptor.get();
    }

    public void start() {
        if (this.loggerConfigDisruptor.isInitialized()) {
            LOGGER.info("Starting AsyncLoggerConfigDisruptor.");
            ((AsyncLoggerConfigDisruptor)this.loggerConfigDisruptor.get()).start();
        }
        super.start();
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        if (this.loggerConfigDisruptor.isInitialized()) {
            LOGGER.info("Stopping AsyncLoggerConfigDisruptor.");
            ((AsyncLoggerConfigDisruptor)this.loggerConfigDisruptor.get()).stop(timeout, timeUnit);
        }
        return super.stop(timeout, timeUnit);
    }

    @PluginFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder
    implements org.apache.logging.log4j.plugins.util.Builder<DisruptorConfiguration> {
        @PluginBuilderAttribute(value="class")
        private @PluginBuilderAttribute(value="class") String factoryClassName;
        @PluginBuilderAttribute
        private String waitFactory;

        public Builder setFactoryClassName(String factoryClassName) {
            this.factoryClassName = factoryClassName;
            return this;
        }

        public Builder setWaitFactory(String waitFactory) {
            this.waitFactory = waitFactory;
            return this;
        }

        public DisruptorConfiguration build() {
            return new DisruptorConfiguration(Builder.createWaitStrategyFactory(Objects.toString(this.waitFactory, this.factoryClassName)));
        }

        private static AsyncWaitStrategyFactory createWaitStrategyFactory(String factoryClassName) {
            if (factoryClassName != null) {
                try {
                    AsyncWaitStrategyFactory asyncWaitStrategyFactory = (AsyncWaitStrategyFactory)LoaderUtil.newCheckedInstanceOf((String)factoryClassName, AsyncWaitStrategyFactory.class);
                    LOGGER.info("Using configured AsyncWaitStrategy factory {}.", (Object)factoryClassName);
                    return asyncWaitStrategyFactory;
                }
                catch (ClassCastException e) {
                    LOGGER.error("Ignoring factory '{}': it is not assignable to AsyncWaitStrategyFactory", (Object)factoryClassName);
                }
                catch (LinkageError | ReflectiveOperationException e) {
                    LOGGER.warn("Invalid implementation class name value: error creating AsyncWaitStrategyFactory {}: {}", (Object)factoryClassName, (Object)e.getMessage(), (Object)e);
                }
            }
            LOGGER.info("Using default AsyncWaitStrategy factory.");
            return null;
        }
    }
}

