/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.async.logger;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventTranslator;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.async.logger.AsyncWaitStrategyFactory;
import org.apache.logging.log4j.async.logger.DisruptorUtil;
import org.apache.logging.log4j.async.logger.RingBufferLogEvent;
import org.apache.logging.log4j.async.logger.RingBufferLogEventHandler;
import org.apache.logging.log4j.async.logger.RingBufferLogEventTranslator;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicyFactory;
import org.apache.logging.log4j.core.async.DiscardingAsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.EventRoute;
import org.apache.logging.log4j.core.impl.Log4jPropertyKey;
import org.apache.logging.log4j.core.util.Log4jThread;
import org.apache.logging.log4j.core.util.Log4jThreadFactory;
import org.apache.logging.log4j.core.util.Throwables;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.PropertyKey;

class AsyncLoggerDisruptor
extends AbstractLifeCycle {
    private static final int SLEEP_MILLIS_BETWEEN_DRAIN_ATTEMPTS = 50;
    private static final int MAX_DRAIN_ATTEMPTS_BEFORE_SHUTDOWN = 200;
    private final Lock startLock = new ReentrantLock();
    private final Lock queueFullEnqueueLock = new ReentrantLock();
    private volatile Disruptor<RingBufferLogEvent> disruptor;
    private String contextName;
    private final Supplier<AsyncWaitStrategyFactory> waitStrategyFactorySupplier;
    private long backgroundThreadId;
    private AsyncQueueFullPolicy asyncQueueFullPolicy;
    private WaitStrategy waitStrategy;

    AsyncLoggerDisruptor(String contextName, Supplier<AsyncWaitStrategyFactory> waitStrategyFactorySupplier) {
        this.contextName = contextName;
        this.waitStrategyFactorySupplier = Objects.requireNonNull(waitStrategyFactorySupplier, "waitStrategyFactorySupplier");
    }

    WaitStrategy getWaitStrategy() {
        return this.waitStrategy;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String name) {
        this.contextName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.startLock.lock();
        try {
            if (this.disruptor != null) {
                LOGGER.trace("[{}] AsyncLoggerDisruptor not starting new disruptor for this context, using existing object.", (Object)this.contextName);
                return;
            }
            if (this.isStarting()) {
                LOGGER.trace("[{}] AsyncLoggerDisruptor is already starting.", (Object)this.contextName);
                return;
            }
            this.setStarting();
            LOGGER.trace("[{}] AsyncLoggerDisruptor creating new disruptor for this context.", (Object)this.contextName);
            int ringBufferSize = DisruptorUtil.calculateRingBufferSize((PropertyKey)Log4jPropertyKey.ASYNC_LOGGER_RING_BUFFER_SIZE);
            AsyncWaitStrategyFactory factory = this.waitStrategyFactorySupplier.get();
            this.waitStrategy = DisruptorUtil.createWaitStrategy((PropertyKey)Log4jPropertyKey.ASYNC_LOGGER_WAIT_STRATEGY, factory);
            Log4jThreadFactory threadFactory = new Log4jThreadFactory("AsyncLogger[" + this.contextName + "]", true, 5){

                public Thread newThread(Runnable r) {
                    Thread result = super.newThread(r);
                    AsyncLoggerDisruptor.this.backgroundThreadId = result.getId();
                    return result;
                }
            };
            this.asyncQueueFullPolicy = AsyncQueueFullPolicyFactory.create();
            this.disruptor = new Disruptor(RingBufferLogEvent.FACTORY, ringBufferSize, (ThreadFactory)threadFactory, ProducerType.MULTI, this.waitStrategy);
            ExceptionHandler<RingBufferLogEvent> errorHandler = DisruptorUtil.getAsyncLoggerExceptionHandler();
            this.disruptor.setDefaultExceptionHandler(errorHandler);
            EventHandler[] handlers = new RingBufferLogEventHandler[]{new RingBufferLogEventHandler()};
            this.disruptor.handleEventsWith(handlers);
            LOGGER.debug("[{}] Starting AsyncLogger disruptor for this context with ringbufferSize={}, waitStrategy={}, exceptionHandler={}...", (Object)this.contextName, (Object)this.disruptor.getRingBuffer().getBufferSize(), (Object)this.waitStrategy.getClass().getSimpleName(), errorHandler);
            this.disruptor.start();
            super.start();
        }
        finally {
            this.startLock.unlock();
        }
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        Disruptor<RingBufferLogEvent> temp = this.disruptor;
        if (temp == null) {
            LOGGER.trace("[{}] AsyncLoggerDisruptor: disruptor for this context already shut down.", (Object)this.contextName);
            return true;
        }
        this.setStopping();
        LOGGER.debug("[{}] AsyncLoggerDisruptor: shutting down disruptor for this context.", (Object)this.contextName);
        this.disruptor = null;
        for (int i = 0; AsyncLoggerDisruptor.hasBacklog(temp) && i < 200; ++i) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            temp.shutdown(timeout, timeUnit);
        }
        catch (TimeoutException e) {
            LOGGER.warn("[{}] AsyncLoggerDisruptor: shutdown timed out after {} {}", (Object)this.contextName, (Object)timeout, (Object)timeUnit);
            temp.halt();
        }
        LOGGER.trace("[{}] AsyncLoggerDisruptor: disruptor has been shut down.", (Object)this.contextName);
        if (DiscardingAsyncQueueFullPolicy.getDiscardCount((AsyncQueueFullPolicy)this.asyncQueueFullPolicy) > 0L) {
            LOGGER.trace("AsyncLoggerDisruptor: {} discarded {} events.", (Object)this.asyncQueueFullPolicy, (Object)DiscardingAsyncQueueFullPolicy.getDiscardCount((AsyncQueueFullPolicy)this.asyncQueueFullPolicy));
        }
        this.setStopped();
        return true;
    }

    private static boolean hasBacklog(Disruptor<?> theDisruptor) {
        RingBuffer ringBuffer = theDisruptor.getRingBuffer();
        return !ringBuffer.hasAvailableCapacity(ringBuffer.getBufferSize());
    }

    EventRoute getEventRoute(Level logLevel) {
        int remainingCapacity = this.remainingDisruptorCapacity();
        if (remainingCapacity < 0) {
            return EventRoute.DISCARD;
        }
        return this.asyncQueueFullPolicy.getRoute(this.backgroundThreadId, logLevel);
    }

    private int remainingDisruptorCapacity() {
        Disruptor<RingBufferLogEvent> temp = this.disruptor;
        if (this.hasLog4jBeenShutDown(temp)) {
            return -1;
        }
        return (int)temp.getRingBuffer().remainingCapacity();
    }

    private boolean hasLog4jBeenShutDown(Disruptor<RingBufferLogEvent> aDisruptor) {
        if (aDisruptor == null) {
            LOGGER.warn("Ignoring log event after log4j was shut down");
            return true;
        }
        return false;
    }

    boolean tryPublish(RingBufferLogEventTranslator translator) {
        try {
            return this.disruptor.getRingBuffer().tryPublishEvent((EventTranslator)translator);
        }
        catch (NullPointerException npe) {
            this.logWarningOnNpeFromDisruptorPublish(translator);
            return false;
        }
    }

    void enqueueLogMessageWhenQueueFull(RingBufferLogEventTranslator translator) {
        block6: {
            try {
                if (this.synchronizeEnqueueWhenQueueFull()) {
                    this.queueFullEnqueueLock.lock();
                    try {
                        this.disruptor.publishEvent((EventTranslator)translator);
                        break block6;
                    }
                    finally {
                        this.queueFullEnqueueLock.unlock();
                    }
                }
                this.disruptor.publishEvent((EventTranslator)translator);
            }
            catch (NullPointerException npe) {
                this.logWarningOnNpeFromDisruptorPublish(translator);
            }
        }
    }

    private boolean synchronizeEnqueueWhenQueueFull() {
        return DisruptorUtil.ASYNC_LOGGER_SYNCHRONIZE_ENQUEUE_WHEN_QUEUE_FULL && this.backgroundThreadId != Thread.currentThread().getId() && !(Thread.currentThread() instanceof Log4jThread);
    }

    private void logWarningOnNpeFromDisruptorPublish(RingBufferLogEventTranslator translator) {
        this.logWarningOnNpeFromDisruptorPublish(translator.level, translator.loggerName, translator.message, translator.thrown);
    }

    private void logWarningOnNpeFromDisruptorPublish(Level level, String fqcn, Message msg, Throwable thrown) {
        LOGGER.warn("[{}] Ignoring log event after log4j was shut down: {} [{}] {}{}", (Object)this.contextName, (Object)level, (Object)fqcn, (Object)msg.getFormattedMessage(), thrown == null ? "" : Throwables.toStringList((Throwable)thrown));
    }

    RingBuffer<RingBufferLogEvent> getRingBuffer() {
        return this.disruptor.getRingBuffer();
    }
}

