<!-- vim: set syn=markdown : -->
<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements. See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at

         http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

# Log4j 2 Compatibility with Log4j 1

## API Compatibility

Log4j 2 provides support for the Log4j 1 logging methods by providing alternate implementations 
of the classes containing those methods. These classes may be found in the log4j-1.2-api jar 
distributed with the project. All calls to perform logging will result in the data passed to the logging methods
to be forwarded to the Log4j2 API where they can be processed by implementations of the Log4j 2 API. 

## Configuration Compatibility

Log4j 2 provides experimental support for Log4j 1 configuration files. Configuration of the Appenders, Layouts 
and Filters that were provided in the Log4j 1 distribution will be redirected to their Log4j 2 counterparts - 
with the exception of the implemented Rewrite Policies. This means that although the while the behavior of these 
components will be similar they may not be exactly the same. For example, the XML generated by the XMLLayout may 
not exactly match the XML generated by the Log4j 1XMLLayout. 

In addition, Log4j 2 supports custom Log4j 1 Appenders, Filters, and Layouts with some constraints. Since the 
original Log4j 1 components may not be present in Log4j 2, custom components that extend them will fail. 

As support for Log4j 1 is an experimental feature one of the following steps must be taken to enable it:

1. Set the system property "log4j1.compatibility" to a value of "true". Log4j 2 will then add log4j.properties,
log4j-test.properties, log4j.xml and log4j-test.xml to the configuration files it searches for on the class path.
1. Set the Log4j 1 system property "log4j.configuration" to the location of the log4j 1 configuration file. The 
files must have a file extension of either ".properties" or ".xml".

## Supported Components
### Appenders

* AsyncAppender
* ConsoleAppender
* DailyRollingFileAppender
* FileAppender
* NullAppender
* RewriteAppender (limited)
* RollingFileAppender
* SyslogAppender

## Filters

* DenyAllFilter
* LevelMatchFilter
* LevelRangeFilter
* StringMatchFilter

## Layouts

* HtmlLayout
* PatternLayout
* SimpleLayout
* TTCCLayout
* XmlLayout

## Rewrite Policies

* MapRewritePolicy
* PropertyRewritePolicy

## Unsupported or Unimplemented Components
### Appenders

* JDBCAppender (cannot be mapped to Log4j 2's JdbcAppender)
* SocketAppender (Requires the use of the SerializedLayout which is a security risk)
* SocketHubAppender (Requires the use of the SerializedLayout which is a securiy risk)
* TelnetAppender (Security risk)

## Rewrite Policies

* ReflectionRewritePolicy
* Custom rewrite policies since LoggingEvent is currently a no-op.

### Renderers
Log4j 2 currently will ignore renderers.