/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jackson.layout;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.core.util.StringBuilderWriter;
import org.apache.logging.log4j.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.plugins.PluginElement;

abstract class AbstractJacksonLayout
extends AbstractStringLayout {
    protected static final String DEFAULT_EOL = "\r\n";
    protected static final String COMPACT_EOL = "";
    protected final String eol;
    protected final ObjectWriter objectWriter;
    protected final boolean compact;
    protected final boolean complete;
    protected final boolean includeNullDelimiter;
    protected final ResolvableKeyValuePair[] additionalFields;

    private static LogEvent convertMutableToLog4jEvent(LogEvent event) {
        return event instanceof Log4jLogEvent ? event : event.toMemento();
    }

    private static ResolvableKeyValuePair[] prepareAdditionalFields(Configuration config, KeyValuePair[] additionalFields) {
        if (additionalFields == null || additionalFields.length == 0) {
            return new ResolvableKeyValuePair[0];
        }
        ResolvableKeyValuePair[] resolvableFields = new ResolvableKeyValuePair[additionalFields.length];
        for (int i = 0; i < additionalFields.length; ++i) {
            ResolvableKeyValuePair resolvable = resolvableFields[i] = new ResolvableKeyValuePair(additionalFields[i]);
            if (config != null || !resolvable.valueNeedsLookup) continue;
            throw new IllegalArgumentException("configuration needs to be set when there are additional fields with variables");
        }
        return resolvableFields;
    }

    protected static boolean valueNeedsLookup(String value) {
        return value != null && value.contains("${");
    }

    protected AbstractJacksonLayout(Configuration config, ObjectWriter objectWriter, Charset charset, boolean compact, boolean complete, boolean eventEol, AbstractStringLayout.Serializer headerSerializer, AbstractStringLayout.Serializer footerSerializer, boolean includeNullDelimiter, KeyValuePair[] additionalFields) {
        this(config, objectWriter, charset, compact, complete, eventEol, null, headerSerializer, footerSerializer, includeNullDelimiter, additionalFields);
    }

    protected AbstractJacksonLayout(Configuration config, ObjectWriter objectWriter, Charset charset, boolean compact, boolean complete, boolean eventEol, String endOfLine, AbstractStringLayout.Serializer headerSerializer, AbstractStringLayout.Serializer footerSerializer, boolean includeNullDelimiter, KeyValuePair[] additionalFields) {
        super(config, charset, headerSerializer, footerSerializer);
        this.objectWriter = objectWriter;
        this.compact = compact;
        this.complete = complete;
        this.eol = endOfLine != null ? endOfLine : (compact && !eventEol ? COMPACT_EOL : DEFAULT_EOL);
        this.includeNullDelimiter = includeNullDelimiter;
        this.additionalFields = AbstractJacksonLayout.prepareAdditionalFields(config, additionalFields);
    }

    protected LogEventWrapperWithAdditionalFields createLogEventWrapperWithAdditionalFields(LogEvent event, Map<String, String> additionalFieldsMap) {
        return new LogEventWrapperWithAdditionalFields(event, additionalFieldsMap);
    }

    private Map<String, String> resolveAdditionalFields(LogEvent logEvent) {
        LinkedHashMap<String, String> additionalFieldsMap = new LinkedHashMap<String, String>(this.additionalFields.length);
        StrSubstitutor strSubstitutor = this.configuration.getStrSubstitutor();
        for (ResolvableKeyValuePair pair : this.additionalFields) {
            if (pair.valueNeedsLookup) {
                additionalFieldsMap.put(pair.key, strSubstitutor.replace(logEvent, pair.value));
                continue;
            }
            additionalFieldsMap.put(pair.key, pair.value);
        }
        return additionalFieldsMap;
    }

    public String toSerializable(LogEvent event) {
        StringBuilderWriter writer = new StringBuilderWriter();
        try {
            this.toSerializable(event, (Writer)writer);
            return writer.toString();
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
            return COMPACT_EOL;
        }
    }

    public void toSerializable(LogEvent event, Writer writer) throws JsonGenerationException, JsonMappingException, IOException {
        this.objectWriter.writeValue(writer, this.wrapLogEvent(AbstractJacksonLayout.convertMutableToLog4jEvent(event)));
        writer.write(this.eol);
        if (this.includeNullDelimiter) {
            writer.write(0);
        }
        this.markEvent();
    }

    protected Object wrapLogEvent(LogEvent event) {
        if (this.additionalFields.length > 0) {
            Map<String, String> additionalFieldsMap = this.resolveAdditionalFields(event);
            return this.createLogEventWrapperWithAdditionalFields(event, additionalFieldsMap);
        }
        return event;
    }

    protected static class ResolvableKeyValuePair {
        final String key;
        final String value;
        final boolean valueNeedsLookup;

        ResolvableKeyValuePair(KeyValuePair pair) {
            this.key = pair.getKey();
            this.value = pair.getValue();
            this.valueNeedsLookup = AbstractJacksonLayout.valueNeedsLookup(this.value);
        }
    }

    @JsonRootName(value="Event")
    public static class LogEventWrapperWithAdditionalFields {
        private final Object logEvent;
        private final Map<String, String> additionalFields;

        public LogEventWrapperWithAdditionalFields(Object logEvent, Map<String, String> additionalFields) {
            this.logEvent = logEvent;
            this.additionalFields = additionalFields;
        }

        @JsonAnyGetter
        public Map<String, String> getAdditionalFields() {
            return this.additionalFields;
        }

        @JsonUnwrapped
        public Object getLogEvent() {
            return this.logEvent;
        }
    }

    public static abstract class Builder<B extends Builder<B>>
    extends AbstractStringLayout.Builder<B> {
        @PluginBuilderAttribute
        private boolean eventEol;
        @PluginBuilderAttribute
        private String endOfLine;
        @PluginBuilderAttribute
        private boolean compact;
        @PluginBuilderAttribute
        private boolean complete;
        @PluginBuilderAttribute
        private boolean locationInfo;
        @PluginBuilderAttribute
        private boolean properties;
        @PluginBuilderAttribute
        private boolean includeStacktrace = true;
        @PluginBuilderAttribute
        private boolean stacktraceAsString = false;
        @PluginBuilderAttribute
        private boolean includeNullDelimiter = false;
        @PluginElement(value="AdditionalField")
        private @PluginElement(value="AdditionalField") KeyValuePair[] additionalFields;

        public KeyValuePair[] getAdditionalFields() {
            return this.additionalFields;
        }

        public boolean getEventEol() {
            return this.eventEol;
        }

        public String getEndOfLine() {
            return this.endOfLine;
        }

        public boolean isCompact() {
            return this.compact;
        }

        public boolean isComplete() {
            return this.complete;
        }

        public boolean isIncludeNullDelimiter() {
            return this.includeNullDelimiter;
        }

        public boolean isIncludeStacktrace() {
            return this.includeStacktrace;
        }

        public boolean isLocationInfo() {
            return this.locationInfo;
        }

        public boolean isProperties() {
            return this.properties;
        }

        public boolean isStacktraceAsString() {
            return this.stacktraceAsString;
        }

        public B setAdditionalFields(KeyValuePair[] additionalFields) {
            this.additionalFields = additionalFields;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setCompact(boolean compact) {
            this.compact = compact;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setComplete(boolean complete) {
            this.complete = complete;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setEventEol(boolean eventEol) {
            this.eventEol = eventEol;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setEndOfLine(String endOfLine) {
            this.endOfLine = endOfLine;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setIncludeNullDelimiter(boolean includeNullDelimiter) {
            this.includeNullDelimiter = includeNullDelimiter;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setIncludeStacktrace(boolean includeStacktrace) {
            this.includeStacktrace = includeStacktrace;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setLocationInfo(boolean locationInfo) {
            this.locationInfo = locationInfo;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setProperties(boolean properties) {
            this.properties = properties;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setStacktraceAsString(boolean stacktraceAsString) {
            this.stacktraceAsString = stacktraceAsString;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        protected String toStringOrNull(byte[] header) {
            return header == null ? null : new String(header, Charset.defaultCharset());
        }
    }
}

