/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jackson;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.jackson.ContextDataAsEntryListDeserializer;
import org.apache.logging.log4j.jackson.ContextDataAsEntryListSerializer;
import org.apache.logging.log4j.jackson.Log4jStackTraceElementDeserializer;
import org.apache.logging.log4j.jackson.MessageSerializer;
import org.apache.logging.log4j.jackson.SimpleMessageDeserializer;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.ReadOnlyStringMap;

@JsonRootName(value="Event")
@JsonFilter(value="org.apache.logging.log4j.core.impl.Log4jLogEvent")
@JsonPropertyOrder(value={"timeMillis", "Instant", "threadName", "level", "loggerName", "marker", "message", "thrown", "ContextMap", "contextStack", "loggerFQCN", "Source", "endOfBatch"})
abstract class LogEventWithContextListMixIn
implements LogEvent {
    LogEventWithContextListMixIn() {
    }

    @JsonProperty(value="contextMap")
    @JsonSerialize(using=ContextDataAsEntryListSerializer.class)
    @JsonDeserialize(using=ContextDataAsEntryListDeserializer.class)
    public abstract ReadOnlyStringMap getContextData();

    @JsonProperty(value="contextStack")
    public abstract ThreadContext.ContextStack getContextStack();

    @JsonProperty(value="instant")
    public abstract Instant getInstant();

    @JsonProperty
    public abstract Level getLevel();

    @JsonProperty
    public abstract String getLoggerFqcn();

    @JsonProperty
    public abstract String getLoggerName();

    @JsonProperty(value="marker")
    public abstract Marker getMarker();

    @JsonProperty(value="message")
    @JsonSerialize(using=MessageSerializer.class)
    @JsonDeserialize(using=SimpleMessageDeserializer.class)
    public abstract Message getMessage();

    @JsonProperty(value="source")
    @JsonDeserialize(using=Log4jStackTraceElementDeserializer.class)
    public abstract StackTraceElement getSource();

    @JsonProperty(value="threadId")
    public abstract long getThreadId();

    @JsonProperty(value="thread")
    public abstract String getThreadName();

    @JsonProperty(value="threadPriority")
    public abstract int getThreadPriority();

    @JsonIgnore
    public abstract Throwable getThrown();

    @JsonProperty(value="thrown")
    public abstract ThrowableProxy getThrownProxy();

    @JsonProperty(value="timeMillis", access=JsonProperty.Access.READ_ONLY)
    public abstract long getTimeMillis();

    @JsonProperty
    public abstract boolean isEndOfBatch();

    @JsonIgnore
    public abstract boolean isIncludeLocation();

    public abstract void setEndOfBatch(boolean var1);

    public abstract void setIncludeLocation(boolean var1);
}

