/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.logging.log4j.core.impl.ExtendedClassInfo;

@JsonPropertyOrder(value={"classLoaderName", "module", "moduleVersion", "class", "method", "file", "line", "exact", "location", "version"})
public abstract class ExtendedStackTraceElementMixIn {
    protected static final String ATTR_CLASS_LOADER_NAME = "classLoaderName";
    protected static final String ATTR_MODULE = "module";
    protected static final String ATTR_MODULE_VERSION = "moduleVersion";
    protected static final String ATTR_CLASS = "class";
    protected static final String ATTR_METHOD = "method";
    protected static final String ATTR_FILE = "file";
    protected static final String ATTR_LINE = "line";
    protected static final String ATTR_EXACT = "exact";
    protected static final String ATTR_LOCATION = "location";
    protected static final String ATTR_VERSION = "version";

    @JsonCreator
    public ExtendedStackTraceElementMixIn(@JsonProperty(value="classLoaderName") String classLoaderName, @JsonProperty(value="module") String moduleName, @JsonProperty(value="moduleVersion") String moduleVersion, @JsonProperty(value="class") String declaringClass, @JsonProperty(value="method") String methodName, @JsonProperty(value="file") String fileName, @JsonProperty(value="line") int lineNumber, @JsonProperty(value="exact") boolean exact, @JsonProperty(value="location") String location, @JsonProperty(value="version") String version) {
    }

    @JsonProperty(value="classLoaderName")
    public abstract String getClassLoaderName();

    @JsonProperty(value="module")
    public abstract String getModuleName();

    @JsonProperty(value="moduleVersion")
    public abstract String getModuleVersion();

    @JsonProperty(value="class")
    public abstract String getClassName();

    @JsonProperty(value="exact")
    public abstract boolean getExact();

    @JsonIgnore
    public abstract ExtendedClassInfo getExtraClassInfo();

    @JsonProperty(value="file")
    public abstract String getFileName();

    @JsonProperty(value="line")
    public abstract int getLineNumber();

    @JsonProperty(value="location")
    public abstract String getLocation();

    @JsonProperty(value="method")
    public abstract String getMethodName();

    @JsonIgnore
    abstract StackTraceElement getStackTraceElement();

    @JsonProperty(value="version")
    public abstract String getVersion();

    @JsonIgnore
    public abstract boolean isNativeMethod();
}

