/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.csv.layout;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.QuoteMode;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.csv.layout.AbstractCsvLayout;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAttribute;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.status.StatusLogger;

@Configurable(elementType="layout", printObject=true)
@Plugin
public class CsvParameterLayout
extends AbstractCsvLayout {
    public static AbstractCsvLayout createDefaultLayout() {
        return new CsvParameterLayout((Configuration)new DefaultConfiguration(), Charset.forName("UTF-8"), CSVFormat.valueOf((String)"Default"), null, null);
    }

    public static AbstractCsvLayout createLayout(CSVFormat format) {
        return new CsvParameterLayout((Configuration)new DefaultConfiguration(), Charset.forName("UTF-8"), format, null, null);
    }

    @PluginFactory
    public static AbstractCsvLayout createLayout(@PluginConfiguration Configuration config, @PluginAttribute(defaultString="Default") @PluginAttribute(defaultString="Default") String format, @PluginAttribute Character delimiter, @PluginAttribute Character escape, @PluginAttribute Character quote, @PluginAttribute QuoteMode quoteMode, @PluginAttribute String nullString, @PluginAttribute String recordSeparator, @PluginAttribute(defaultString="UTF-8") @PluginAttribute(defaultString="UTF-8") Charset charset, @PluginAttribute String header, @PluginAttribute String footer) {
        CSVFormat csvFormat = CsvParameterLayout.createFormat(format, delimiter, escape, quote, quoteMode, nullString, recordSeparator);
        return new CsvParameterLayout(config, charset, csvFormat, header, footer);
    }

    public CsvParameterLayout(Configuration config, Charset charset, CSVFormat csvFormat, String header, String footer) {
        super(config, charset, csvFormat, header, footer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toSerializable(LogEvent event) {
        Message message = event.getMessage();
        Object[] parameters = message.getParameters();
        StringBuilder buffer = (StringBuilder)this.stringBuilderRecycler.acquire();
        try {
            this.getFormat().printRecord((Appendable)buffer, parameters);
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            StatusLogger.getLogger().error(message, (Throwable)e);
            String string = this.getFormat().getCommentMarker() + " " + e;
            return string;
        }
        finally {
            this.stringBuilderRecycler.release((Object)buffer);
        }
    }
}

